/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import net.sf.sahi.WebProcessor;
import net.sf.sahi.config.Configuration;

public class WebServer {
    private int port = 10000;

    public WebServer(int port) {
        this.port = port;
    }

    public static void main(String[] args) {
        try {
            new WebServer(Configuration.getPort() + 1).startProxy();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startProxy() throws IOException {
        ServerSocket server = null;
        try {
            server = new ServerSocket(this.port);
            System.out.println(">>>> Sahi demo web server started. Listening on port:" + this.port);
            while (true) {
                Socket client = server.accept();
                new Thread(new WebProcessor(client)).start();
            }
        }
        catch (Throwable throwable) {
            if (server != null) {
                server.close();
            }
            throw throwable;
        }
    }

    static {
        Configuration.init("..", "../userdata/");
    }
}

