/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.test;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.sf.sahi.test.TestRunner;
import net.sf.sahi.util.Utils;

public class SingleSessionTestRunner
extends TestRunner {
    private String initJS;

    public SingleSessionTestRunner(String sessionName, String browserType, String base) {
        super(sessionName, browserType, Utils.replaceLocalhostWithMachineName(base), "1");
        this.setIsSingleSession(true);
        this.sessionId = Utils.generateId();
    }

    public void start() throws IOException, InterruptedException {
        String urlStr = this.buildURL("startSingleSession");
        System.out.println(urlStr);
        Utils.readURL(urlStr);
    }

    public String stop() throws UnsupportedEncodingException, InterruptedException {
        StringBuffer urlStr = new StringBuffer(200).append("http://").append(this.sahiHost).append(":").append(this.port).append("/_s_/dyn/Suite_stopSingleSession?sahisid=").append(SingleSessionTestRunner.encode(this.sessionId));
        Utils.readURL(urlStr.toString());
        return this.getStatus();
    }

    public String executeSingleTest(String testName) throws UnsupportedEncodingException, InterruptedException {
        StringBuffer urlStr = new StringBuffer(200).append("http://").append(this.sahiHost).append(":").append(this.port).append("/_s_/dyn/Suite_executeTestInSingleSession?sahisid=").append(SingleSessionTestRunner.encode(this.sessionId)).append("&testName=").append(SingleSessionTestRunner.encode(testName)).append("&startURL=").append(SingleSessionTestRunner.encode("")).append("&initJS=").append(this.initJS == null ? "" : SingleSessionTestRunner.encode(this.initJS));
        return new String(Utils.readURL(urlStr.toString()));
    }

    public void setInitJS(String initJS) {
        this.initJS = initJS;
    }

    public String getInitJS() {
        return this.initJS;
    }
}

