/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sahi.ant;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class Mailer {
    private Properties props;
    private String host;
    private int port;
    private String username;
    private String password;
    private boolean auth;

    public Mailer(String host, int port) {
        this(host, port, null, null);
    }

    public Mailer(String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.props = new Properties();
        this.props.put("mail.smtp.host", host);
        this.props.put("mail.smtp.port", "" + port);
        if (username != null && username != "") {
            this.username = username;
            this.password = password;
            this.auth = true;
            this.props.put("mail.smtp.user", username);
            this.props.put("mail.smtp.password", password);
            this.props.put("mail.smtp.auth", "true");
        }
    }

    public void send(String from, String to, String subject, String content) throws AddressException, MessagingException {
        Session session = Session.getDefaultInstance((Properties)this.props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        String[] toAddresses = to.split(",");
        for (int i = 0; i < toAddresses.length; ++i) {
            msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddresses[i]));
        }
        msg.setSubject(subject);
        msg.setText(content);
        if (this.auth) {
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, this.port, this.username, this.password);
            msg.saveChanges();
            transport.sendMessage((Message)msg, msg.getAllRecipients());
            transport.close();
        } else {
            Transport.send((Message)msg);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            Mailer mailer = args.length == 8 ? new Mailer(args[0], Integer.parseInt(args[1]), args[6], args[7]) : new Mailer(args[0], Integer.parseInt(args[1]));
            mailer.send(args[2], args[3], args[4], args[5]);
        }
        catch (Exception e) {
            System.out.println("-------------------------------------------------");
            System.out.println("Mailer <host> <port> <from> <to> <subject> <body> <username> <password>");
            System.out.println("-------------------------------------------------");
            e.printStackTrace();
        }
    }
}

