# Configure settings and install targets
# FIXME: Copypasted from Ogre and need lots of changes

if (WIN32)
  set(PagedGeometry_RELEASE_PATH "/Release")
  set(PagedGeometry_RELWDBG_PATH "/RelWithDebInfo")
  set(PagedGeometry_MINSIZE_PATH "/MinSizeRel")
  set(PagedGeometry_DEBUG_PATH "/Debug")
  set(PagedGeometry_LIB_RELEASE_PATH "/Release")
  set(PagedGeometry_LIB_RELWDBG_PATH "/RelWithDebInfo")
  set(PagedGeometry_LIB_MINSIZE_PATH "/MinSizeRel")
  set(PagedGeometry_LIB_DEBUG_PATH "/Debug")
  set(PagedGeometry_PLUGIN_PATH "/opt")
elseif (UNIX)
  set(PagedGeometry_RELEASE_PATH "")
  set(PagedGeometry_RELWDBG_PATH "")
  set(PagedGeometry_MINSIZE_PATH "")
  set(PagedGeometry_DEBUG_PATH "/debug")
  set(PagedGeometry_LIB_RELEASE_PATH "")
  set(PagedGeometry_LIB_RELWDBG_PATH "")
  set(PagedGeometry_LIB_MINSIZE_PATH "")
  set(PagedGeometry_LIB_DEBUG_PATH "")
  set(PagedGeometry_PLUGIN_PATH "/PagedGeometry")
endif ()

# create vcproj.user file for Visual Studio to set debug working directory
function(PagedGeometry_create_vcproj_userfile TARGETNAME)
  if (MSVC)
    configure_file(
	  ${PagedGeometry_TEMPLATES_DIR}/VisualStudioUserFile.vcproj.user.in
	  ${CMAKE_CURRENT_BINARY_DIR}/${TARGETNAME}.vcproj.user
	  @ONLY
	)
  endif ()
endfunction(PagedGeometry_create_vcproj_userfile)

# install targets according to current build type
function(PagedGeometry_install_target TARGETNAME SUFFIX)
  install(TARGETS ${TARGETNAME}
    RUNTIME DESTINATION "bin${PagedGeometry_RELEASE_PATH}" CONFIGURATIONS Release None ""
    LIBRARY DESTINATION "lib${PagedGeometry_LIB_RELEASE_PATH}${SUFFIX}" CONFIGURATIONS Release None ""
    ARCHIVE DESTINATION "lib${PagedGeometry_LIB_RELEASE_PATH}${SUFFIX}" CONFIGURATIONS Release None ""
    FRAMEWORK DESTINATION "bin${PagedGeometry_RELEASE_PATH}" CONFIGURATIONS Release None ""
  )
  install(TARGETS ${TARGETNAME}
    RUNTIME DESTINATION "bin${PagedGeometry_RELWDBG_PATH}" CONFIGURATIONS RelWithDebInfo
    LIBRARY DESTINATION "lib${PagedGeometry_LIB_RELWDBG_PATH}${SUFFIX}" CONFIGURATIONS RelWithDebInfo
    ARCHIVE DESTINATION "lib${PagedGeometry_LIB_RELWDBG_PATH}${SUFFIX}" CONFIGURATIONS RelWithDebInfo
    FRAMEWORK DESTINATION "bin${PagedGeometry_RELWDBG_PATH}" CONFIGURATIONS RelWithDebInfo
  )
  install(TARGETS ${TARGETNAME}
    RUNTIME DESTINATION "bin${PagedGeometry_MINSIZE_PATH}" CONFIGURATIONS MinSizeRel
    LIBRARY DESTINATION "lib${PagedGeometry_LIB_MINSIZE_PATH}${SUFFIX}" CONFIGURATIONS MinSizeRel
    ARCHIVE DESTINATION "lib${PagedGeometry_LIB_MINSIZE_PATH}${SUFFIX}" CONFIGURATIONS MinSizeRel
    FRAMEWORK DESTINATION "bin${PagedGeometry_MINSIZE_PATH}" CONFIGURATIONS MinSizeRel
  )
  install(TARGETS ${TARGETNAME}
    RUNTIME DESTINATION "bin${PagedGeometry_DEBUG_PATH}" CONFIGURATIONS Debug
    LIBRARY DESTINATION "lib${PagedGeometry_LIB_DEBUG_PATH}${SUFFIX}" CONFIGURATIONS Debug
    ARCHIVE DESTINATION "lib${PagedGeometry_LIB_DEBUG_PATH}${SUFFIX}" CONFIGURATIONS Debug
    FRAMEWORK DESTINATION "bin${PagedGeometry_DEBUG_PATH}" CONFIGURATIONS Debug
  )
endfunction(PagedGeometry_install_target)

# setup common target settings
function(PagedGeometry_config_common TARGETNAME)
  set_target_properties(${TARGETNAME} PROPERTIES
    ARCHIVE_OUTPUT_DIRECTORY ${PagedGeometry_BINARY_DIR}/lib
    LIBRARY_OUTPUT_DIRECTORY ${PagedGeometry_BINARY_DIR}/lib
    RUNTIME_OUTPUT_DIRECTORY ${PagedGeometry_BINARY_DIR}/bin
  )
  PagedGeometry_create_vcproj_userfile(${TARGETNAME})
endfunction(PagedGeometry_config_common)

#setup Demo builds
function(PagedGeometry_demo DEMONAME)
	include_directories(.)

	# define the sources
	include(${DEMONAME}.list)
	
	link_directories(${OGRE_LIB_DIR} ${OIS_LIB_DIR})	

	# setup PagedGeometryEngine target
	add_executable(${DEMONAME} WIN32 ${HEADER_FILES} ${SOURCE_FILES})
	
	# add dependencies
	add_dependencies(${DEMONAME} PagedGeometryEngine PagedGeometryFramework OgreRenderSystem)

	PagedGeometry_config_common(${DEMONAME})

	# link libraries against it
	target_link_libraries(${DEMONAME}
		${OGRE_LIBRARIES}
		${OIS_LIBRARIES}
		PagedGeometryEngine
		PagedGeometryFramework
		OgreRenderSystem
		uuid
	)
	
	# install debug pdb files
	install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_DEBUG_PATH}/${SAMPLENAME}.pdb
		DESTINATION bin${PagedGeometry_DEBUG_PATH} CONFIGURATIONS Debug
	)
	install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_RELWDBG_PATH}/${SAMPLENAME}.pdb
		DESTINATION bin${PagedGeometry_RELWDBG_PATH} CONFIGURATIONS RelWithDebInfo
	)

	PagedGeometry_install_target(${DEMONAME} "")
endfunction(PagedGeometry_demo)

#setup Plugin builds
function(PagedGeometry_plugin PLUGINNAME)
	include_directories(.)

	# define the sources
	include(${PLUGINNAME}.list)
	
	add_definitions("-D_USRDLL -DPagedGeometry_BUILD_DLL")
	
	link_directories(${OGRE_LIB_DIR} ${OIS_LIB_DIR})	

	# setup PagedGeometryEngine target
	add_library(${PLUGINNAME} ${PagedGeometry_LIB_TYPE} ${HEADER_FILES} ${SOURCE_FILES})
	
	# add dependencies
	add_dependencies(${PLUGINNAME} PagedGeometryEngine PagedGeometryFramework OgreRenderSystem)

	PagedGeometry_config_common(${PLUGINNAME})

	# link libraries against it
	target_link_libraries(${PLUGINNAME}
		${OGRE_LIBRARIES}
		${OIS_LIBRARIES}
		PagedGeometryEngine
		PagedGeometryFramework
		OgreRenderSystem
		uuid
	)
	
	PagedGeometry_install_target(${PLUGINNAME} "")
	  
	install(FILES ${HEADER_FILES}
		DESTINATION include/PagedGeometryPlugins/${PLUGINNAME}
	)

endfunction(PagedGeometry_plugin)



# setup library build
function(PagedGeometry_config_lib LIBNAME)
  PagedGeometry_config_common(${LIBNAME})
  if (PagedGeometry_STATIC)
    # add static prefix, if compiling static version
    set_target_properties(${LIBNAME} PROPERTIES OUTPUT_NAME ${LIBNAME}Static)
  else (PagedGeometry_STATIC)
    if (CMAKE_COMPILER_IS_GNUCXX)
      # add GCC visibility flags to shared library build
      set_target_properties(${LIBNAME} PROPERTIES COMPILE_FLAGS "${PagedGeometry_GCC_VISIBILITY_FLAGS}")
	endif (CMAKE_COMPILER_IS_GNUCXX)
  endif (PagedGeometry_STATIC)
  PagedGeometry_install_target(${LIBNAME} "")
  
  if (PagedGeometry_INSTALL_PDB)
    # install debug pdb files
    if (PagedGeometry_STATIC)
	  install(FILES ${PagedGeometry_BINARY_DIR}/lib${PagedGeometry_LIB_DEBUG_PATH}/${LIBNAME}Static_d.pdb
	    DESTINATION lib${PagedGeometry_LIB_DEBUG_PATH}
		CONFIGURATIONS Debug
	  )
	  install(FILES ${PagedGeometry_BINARY_DIR}/lib${PagedGeometry_LIB_RELWDBG_PATH}/${LIBNAME}Static.pdb
	    DESTINATION lib${PagedGeometry_LIB_RELWDBG_PATH}
		CONFIGURATIONS RelWithDebInfo
	  )
	else ()
	  install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_DEBUG_PATH}/${LIBNAME}_d.pdb
	    DESTINATION bin${PagedGeometry_DEBUG_PATH}
		CONFIGURATIONS Debug
	  )
	  install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_RELWDBG_PATH}/${LIBNAME}.pdb
	    DESTINATION bin${PagedGeometry_RELWDBG_PATH}
		CONFIGURATIONS RelWithDebInfo
	  )
	endif ()
  endif ()
endfunction(PagedGeometry_config_lib)

# setup plugin build
function(PagedGeometry_config_plugin PLUGINNAME)
  PagedGeometry_config_common(${PLUGINNAME})
  if (PagedGeometry_STATIC)
    # add static prefix, if compiling static version
    set_target_properties(${PLUGINNAME} PROPERTIES OUTPUT_NAME ${PLUGINNAME}Static)
  else (PagedGeometry_STATIC)
    if (CMAKE_COMPILER_IS_GNUCXX)
      # add GCC visibility flags to shared library build
      set_target_properties(${PLUGINNAME} PROPERTIES COMPILE_FLAGS "${PagedGeometry_GCC_VISIBILITY_FLAGS}")
      # disable "lib" prefix on Unix
      set_target_properties(${PLUGINNAME} PROPERTIES PREFIX "")
	endif (CMAKE_COMPILER_IS_GNUCXX)	
  endif (PagedGeometry_STATIC)
  PagedGeometry_install_target(${PLUGINNAME} ${PagedGeometry_PLUGIN_PATH})

  if (PagedGeometry_INSTALL_PDB)
    # install debug pdb files
    if (PagedGeometry_STATIC)
	  install(FILES ${PagedGeometry_BINARY_DIR}/lib${PagedGeometry_LIB_DEBUG_PATH}/${PLUGINNAME}Static_d.pdb
	    DESTINATION lib${PagedGeometry_LIB_DEBUG_PATH}/opt
		CONFIGURATIONS Debug
	  )
	  install(FILES ${PagedGeometry_BINARY_DIR}/lib${PagedGeometry_LIB_RELWDBG_PATH}/${PLUGINNAME}Static.pdb
	    DESTINATION lib${PagedGeometry_LIB_RELWDBG_PATH}/opt
		CONFIGURATIONS RelWithDebInfo
	  )
	else ()
	  install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_DEBUG_PATH}/${PLUGINNAME}_d.pdb
	    DESTINATION bin${PagedGeometry_DEBUG_PATH}
		CONFIGURATIONS Debug
	  )
	  install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_RELWDBG_PATH}/${PLUGINNAME}.pdb
	    DESTINATION bin${PagedGeometry_RELWDBG_PATH}
		CONFIGURATIONS RelWithDebInfo
	  )
	endif ()
  endif ()
endfunction(PagedGeometry_config_plugin)

# setup Ogre demo build
function(PagedGeometry_config_sample SAMPLENAME)
  PagedGeometry_config_common(${SAMPLENAME})

  # set install RPATH for Unix systems
  if (UNIX AND PagedGeometry_FULL_RPATH)
    set_property(TARGET ${SAMPLENAME} APPEND PROPERTY
      INSTALL_RPATH ${CMAKE_INSTALL_PREFIX}/lib)
    set_property(TARGET ${SAMPLENAME} PROPERTY INSTALL_RPATH_USE_LINK_PATH TRUE)
  endif ()
  
endfunction(PagedGeometry_config_sample)

# setup Ogre tool build
function(PagedGeometry_config_tool TOOLNAME)
  PagedGeometry_config_common(${TOOLNAME})

  # set install RPATH for Unix systems
  if (UNIX AND PagedGeometry_FULL_RPATH)
    set_property(TARGET ${TOOLNAME} APPEND PROPERTY
      INSTALL_RPATH ${CMAKE_INSTALL_PREFIX}/lib)
    set_property(TARGET ${TOOLNAME} PROPERTY INSTALL_RPATH_USE_LINK_PATH TRUE)
  endif ()

  if (PagedGeometry_INSTALL_TOOLS)
    PagedGeometry_install_target(${TOOLNAME} "")
    if (PagedGeometry_INSTALL_PDB)
      # install debug pdb files
      install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_DEBUG_PATH}/${TOOLNAME}.pdb
        DESTINATION bin${PagedGeometry_DEBUG_PATH}
        CONFIGURATIONS Debug
        )
      install(FILES ${PagedGeometry_BINARY_DIR}/bin${PagedGeometry_RELWDBG_PATH}/${TOOLNAME}.pdb
        DESTINATION bin${PagedGeometry_RELWDBG_PATH}
        CONFIGURATIONS RelWithDebInfo
        )
    endif ()
  endif ()	

endfunction(PagedGeometry_config_tool)
