#ifndef IFILESYSTEM_H
#define IFILESYSTEM_H

typedef unsigned char __u8;
typedef unsigned short __u16;
typedef unsigned long __u32;
typedef unsigned __int64 __u64;

typedef char __s8;
typedef short __s16;
typedef long __s32;


#ifndef FMT_QWORD
#ifdef _MSC_VER
#define FMT_QWORD "I64d"
#else
#define FMT_QWORD "qd"
#endif
#endif


#ifndef  S_ISCHR
#define S_IFMT       0170000     /* type of file (mask for following) */
#define S_IFIFO      0010000     /* first-in/first-out (pipe) */
#define S_IFCHR      0020000     /* character-special file */
#define S_IFDIR      0040000     /* directory */
#define S_IFBLK      0060000     /* blocking device (not used on NetWare) */
#define S_IFREG      0100000     /* regular */
#define S_IFLNK      0120000     /* symbolic link (not used on NetWare) */
#define S_IFSOCK     0140000     /* Berkeley socket */

#define S_ISFIFO(m)  (((m) & S_IFMT) == S_IFIFO)   /* (e.g.: pipe) */
#define S_ISCHR(m)   (((m) & S_IFMT) == S_IFCHR)   /* (e.g.: console) */
#define S_ISDIR(m)   (((m) & S_IFMT) == S_IFDIR)
#define S_ISBLK(m)   (((m) & S_IFMT) == S_IFBLK)   /* (e.g.: pipe) */
#define S_ISREG(m)   (((m) & S_IFMT) == S_IFREG)
#define S_ISLNK(m)   (((m) & S_IFMT) == S_IFLNK)   /* should be FALSE */
#define S_ISSOCK(m)  (((m) & S_IFMT) == S_IFSOCK)  /* (e.g.: socket) */
#endif

#define UNIX_FILENAME_LENGTH 255

struct UNIX_FILEINFO
{
	__u16	i_mode;		/* File mode (permissions)*/
	__u16	i_uid;		/* Low 16 bits of Owner Uid */
	__u16	i_gid;		/* Low 16 bits of Group Id */
	__u64	i_size;		/* Size in bytes */
	__s32	i_atime;	/* Access time */
	__s32	i_ctime;	/* Creation time */
	__s32	i_mtime;	/* Modification time */
	TCHAR szFileName[UNIX_FILENAME_LENGTH];
};

class IFilesystem : public IUnknown
{
public:
	virtual HANDLE OpenFile(LPCTSTR szFilename) const = 0;
	virtual void ReadFile(HANDLE hFile, LPVOID lpBuffer, DWORD NumberOfBytesToRead, DWORD& NumberOfBytesRead) const = 0;
	virtual void CloseFile(HANDLE hFile) const = 0;
	
	virtual HANDLE FindFirstFile(LPCTSTR szPath) const = 0;
	virtual bool FindNextFile(HANDLE hFind, UNIX_FILEINFO& FileInfo) const = 0;
	virtual void CloseFind(HANDLE hFind) const = 0;
};

#ifdef __cplusplus
extern "C" {
#endif

typedef void (WINAPI* LPFNFoundPartition)(LPCSTR lpszName);

void WINAPI FS_Autodetect( LPFNFoundPartition lpCallback );
IFilesystem* WINAPI FS_CreateInstance( LPCSTR lpszName );
void WINAPI FS_DestroyInstance( IFilesystem* pFilesystem );

#ifdef __cplusplus
}
#endif

#endif // IFilesystem_H


