/*
 * Quantis PCI driver
 *
 * Copyright (c) 2004-2010 id Quantique SA, Carouge/Geneva, Switzerland
 * All rights reserved.
 *
 * ----------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY.
 *
 * ----------------------------------------------------------------------------
 *
 * Alternatively, this software may be distributed under the terms of the
 * terms of the GNU General Public License version 2 as published by the
 * Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * ----------------------------------------------------------------------------
 *
 * For history of changes, ChangeLog.txt
 *
 * This header file describes the register of the Quantis PCI card. The code has been adapted from
 * a microsoft provided sample file.
 *
 Module Name:

    Quantis.h  - Quantis driver definitions

Environment:

    Kernel mode
 */
#ifndef __QUANTIS_H
#define __QUANTIS_H

#include "CommonWindows.h"

QUANTIS_EXTERN_C_START
#include <ntddk.h>
#pragma warning(disable:4201)  // disable nameless struct/union warnings
#include <wdf.h>
#pragma warning(default:4201)

#include "QuantisReg.h"
#include "public.h"
#include "trace.h"

// ----------------------------------------------------------------------------
// Software related defines and equates
// ----------------------------------------------------------------------------

#define MAXIMUM_PHYSICAL_PAGES      16

/* Driver private extension */
typedef struct _QUANTIS_DRIVER_EXTENSION {
   unsigned int            NumberOfCards;
   //WDFWAITLOCK             NbCardsLock;
   WDFSPINLOCK             NbCardsLock;
} QUANTIS_DRIVER_EXTENSION, *PQUANTIS_DRIVER_EXTENSION;

/* Declare the accessor to the QUANTIS_DRIVER_EXTENSION */
WDF_DECLARE_CONTEXT_TYPE_WITH_NAME(QUANTIS_DRIVER_EXTENSION, QuantisGetDrvExt)

//
// The device extension.
//
typedef struct _QUANTIS_DEVICE_EXTENSION {

    WDFDEVICE           Device;                 // A WDFDEVICE handle
    WDFREQUEST          CurrentRequest;         // A WDFREQUEST handle
    WDFINTERRUPT        WdfInterrupt;

    ULONG               MaximumTransferLength;  // Maximum transfer length for adapter
    ULONG               MaximumPhysicalPages;   // Maximum number of breaks adapter

    INTCSR_REG          Intcsr;                 // Accumulated interrupt flags

    PQUANTIS_REG        Regs;                   // Quantis registers ptr
	ModuleMask_t	    ModulesStatusMask;      // Record the modules enabled/disabled by customers

    PUCHAR              PortBase;               // I/O port base address
    ULONG               PortCount;              // Number of assigned ports
    BOOLEAN             PortMapped;             // TRUE if mapped port addr

} QUANTIS_DEVICE_EXTENSION, * PQUANTIS_DEVICE_EXTENSION;

//
// This will generate the function named QuantisGetDevExt to be used for
// retreiving the QUANTIS_DEVICE_EXTENSION pointer.
//
WDF_DECLARE_CONTEXT_TYPE_WITH_NAME(QUANTIS_DEVICE_EXTENSION, QuantisGetDevExt)



typedef struct _INTERRUPT_DATA {
    PVOID Context; // Keep here the context information accessed by the ISR
                    // or with ISR lock held. Not used in this sample.
} INTERRUPT_DATA, *PINTERRUPT_DATA;

WDF_DECLARE_CONTEXT_TYPE_WITH_NAME(INTERRUPT_DATA, QuantisGetInterruptData)

// ----------------------------------------------------------------------------
// Function prototypes
// ----------------------------------------------------------------------------

EVT_WDF_DEVICE_PREPARE_HARDWARE QuantisEvtDevicePrepareHardware;
EVT_WDF_DEVICE_RELEASE_HARDWARE QuantisEvtDeviceReleaseHardware;

EVT_WDF_IO_QUEUE_IO_READ  QuantisEvtIoRead;
EVT_WDF_IO_QUEUE_IO_DEVICE_CONTROL QuantisEvtIoDeviceControl;

EVT_WDF_OBJECT_CONTEXT_CLEANUP QuantisContextCleanup;

EVT_WDF_INTERRUPT_DPC QuantisEvtInterruptDpc;
EVT_WDF_INTERRUPT_ISR QuantisEvtInterruptIsr;

EVT_WDF_DEVICE_D0_ENTRY QuantisEvtDeviceD0Entry;
EVT_WDF_DEVICE_D0_EXIT QuantisEvtDeviceD0Exit;

DRIVER_INITIALIZE DriverEntry;

EVT_WDF_DRIVER_DEVICE_ADD QuantisEvtDeviceAdd;
EVT_WDF_DRIVER_DEVICE_ADD QuantisAddDevice;

EVT_WDF_OBJECT_CONTEXT_CLEANUP QuantisEvtDriverContextCleanup;

QUANTIS_EXTERN_C_END

#endif