/*
 * Quantis Library for Java
 *
 * Copyright (c) 2010 Andxor Soluzioni Informatiche S.r.l.
 *                    Cinisello Balsamo (MI), Italy
 * All rights reserved.
 *
 * ----------------------------------------------------------------------------
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY.
 *
 * ----------------------------------------------------------------------------
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */
package com.andxor.quantis;

import java.security.SecureRandomSpi;

import com.idquantique.quantis.Quantis;
import com.idquantique.quantis.QuantisException;

public class QuantisRandom extends SecureRandomSpi {
    
    private Quantis rng;
    
    public QuantisRandom() {
	rng = new Quantis(Quantis.QuantisDeviceType.QUANTIS_DEVICE_PCI, 0);
    }
    
    @Override
    protected byte[] engineGenerateSeed(int numBytes) {
	try {
	    return rng.Read(numBytes);
	} catch (QuantisException e) {
	    throw new RuntimeException(e);
	}
    }

    @Override
    protected void engineNextBytes(byte[] bytes) {
	int len = bytes.length;
	byte[] buffer = engineGenerateSeed(len);
	System.arraycopy(buffer, 0, bytes, 0, len);
    }

    @Override
    protected void engineSetSeed(byte[] seed) {}

}
