<?xml version="1.0"?>
<!--

   qooxdoo - the new era of web development

   http://qooxdoo.org

   Copyright:
     2007 1&1 Internet AG, Germany, http://www.1and1.org

   License:
     LGPL: http://www.gnu.org/licenses/lgpl.html
     EPL: http://www.eclipse.org/org/documents/epl-v10.php
     See the LICENSE file in the project's top-level directory for details.

   Authors:
     * Thomas Herchenroeder (thron7)

-->

<!--
 NAME
	qx-xml2qx-json.xsl  - transform qooxdoo APIViewer XML to qooxdoo APIViewer
                           JSON
	
 SYNTAX
	xsltproc qx-xml2qx-json.xsl <file>.xml
	
	<file>.xml  - An XML file of the format as generated by the
                  -api-documentation-xml-file option of generator.py
	
 DESCRIPTION
	This XSLT forms XML as would be generated by the
    -api-documentation-xml-file option of the generator.py into the JSON format
    that is accepted by qooxdoo's APIViewer application (named "apidata.js" in
    the app). This way, all XML sources that conform to the APIViewer schema can
    be used as input for the APIViewer.
	
	To validate the input XML use the qx-xml.rn[gc] RelaxNG schema.

 SEE ALSO
    pydoc2qx-xml.xsl
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output omit-xml-declaration="yes"/>
	
    <xsl:template match="/child::*">
		<xsl:call-template name="map"/>
	</xsl:template>
	
	<xsl:template name="map">
		<xsl:param name="Indent"/>
		<xsl:if test="not(name()='text')">  <!-- skip text nodes, see further -->
			<xsl:text>&#xa;</xsl:text>
			<xsl:value-of select="$Indent"/>
			<xsl:text>{type:"</xsl:text>
			<xsl:value-of select="name()"/>
			<xsl:text>",attributes:{</xsl:text>
			<xsl:call-template name="attribs"/>
			<xsl:if test="name()='desc'">  <!-- lift <text> child into attribute -->
				<xsl:text>"text":"</xsl:text>
				<xsl:value-of select="normalize-space(string(text))"/>
				<xsl:text>"</xsl:text>
			</xsl:if>
			<xsl:text>},children:[</xsl:text>
			<xsl:for-each select="child::*">
				<xsl:call-template name="map">
					<xsl:with-param name="Indent" select="concat($Indent,'  ')"/>
				</xsl:call-template>
				<xsl:if test="not(last()=position())">
					<xsl:text>,</xsl:text>
				</xsl:if>
			</xsl:for-each>
			<xsl:text>&#xa;</xsl:text>
			<xsl:value-of select="$Indent"/>
			<xsl:text>]}</xsl:text>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="attribs">
		<xsl:for-each select="./attribute::*">
			<xsl:text>"</xsl:text>
			<xsl:value-of select="name()"/>
			<xsl:text>":"</xsl:text>
			<xsl:value-of select="."/>
			<xsl:text>"</xsl:text>
			<xsl:if test="not(last()=position())">
  			  <xsl:text>,</xsl:text>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
    
  
</xsl:stylesheet>
