<?xml version="1.0"?>
<!--

   qooxdoo - the new era of web development

   http://qooxdoo.org

   Copyright:
     2007 1&1 Internet AG, Germany, http://www.1and1.org

   License:
     LGPL: http://www.gnu.org/licenses/lgpl.html
     EPL: http://www.eclipse.org/org/documents/epl-v10.php
     See the LICENSE file in the project's top-level directory for details.

   Authors:
     * Thomas Herchenroeder (thron7)

-->
<!--
 NAME
    pydoc2qx-xml.xsl  - transform Pythondoc XML to qooxdoo APIViewer XML
	
 SYNTAX
    xsltproc pydoc2qx-xml.xsl <pydoc-output>.xml
	
    <pydoc-output>.xml  - An XML file generated by invoking pythondoc.py -x on a 
                           Python source file
	
 DESCRIPTION
    This XSLT file helps to transform XML as generated by the doc extractor 
    Pythondoc (pythondoc.py) into an XML format as it would be generated by the
    -api-documentation-xml-file option of the generator.py. This is an
    intermediate step to arrive at the JSON format that is used by the qooxdoo
    APIViewer as input data ("apidata.js").

    The advantage of this intermediate step is to have a separate tool,
    qx-xml2qx-json.xsl, that transforms between the qooxdoo XML and JSON
    formats. This way, suitable XML from any source can be converted into the
    APIViewer JSON input data.

 CAVEAT
    Currently, this style-sheet *does not* generate the two top-most XML nodes,
    <doctree> and <packages>, to allow integration of multiple modules in a single
    package. That means the output of this style-sheet has to be wrapped into a 
      <doctree>
        <packages>
        ...
        </packages>
      </doctree>
    frame, in order to provide well-formed qooxdoo XML.
	
 SEE ALSO
    qx-xml2qx-json.xsl  - transforming qooxdoo APIViewer XML into qooxdoo
                          APIViewer JSON format
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output omit-xml-declaration="yes"/>

  <xsl:template match="module">
	<xsl:variable name="packName" select="@name"/>
	<xsl:element name="package">
		<xsl:call-template name="package">
			<xsl:with-param name="packName" select="$packName"/>
		</xsl:call-template>
	</xsl:element>
  </xsl:template>

  <xsl:template name="package">
	  <xsl:param name="packName"/>
      <xsl:attribute name="packageName"><xsl:value-of select="$packName"/></xsl:attribute>
      <xsl:attribute name="fullName"><xsl:value-of select="$packName"/></xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="$packName"/></xsl:attribute>
	  <xsl:apply-templates select="infoX"/> <!-- avoid descriptions curr. -->
	  <xsl:element name="classes">
		<xsl:apply-templates select="class">
			<xsl:with-param name="packName" select="$packName"/>
		</xsl:apply-templates>
		<!-- Put top-level functions in a pseudo class -->
		<xsl:element name="class">
		  <xsl:attribute name="packageName"><xsl:value-of select="$packName"/></xsl:attribute>
		  <xsl:attribute name="fullName"><xsl:value-of select="concat($packName,'._Module_Functions_')"/></xsl:attribute>
		  <xsl:attribute name="name">_Module_Functions_</xsl:attribute>
		  <xsl:element name="methods">
			<xsl:apply-templates select="function"/>
		  </xsl:element>
		</xsl:element>
	  </xsl:element>
	  <!-- Here is were functions should go
	  <xsl:element name="functions">
		<xsl:apply-templates select="function"/>
	  </xsl:element>
	  -->
  </xsl:template>

  <xsl:template match="info1">
    <xsl:element name="description">
      <xsl:value-of select="summary"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="class">
	<xsl:param name="packName"/>
    <xsl:element name="class">
      <xsl:attribute name="packageName"><xsl:value-of select="$packName"/></xsl:attribute>
      <xsl:attribute name="fullName"><xsl:value-of select="@name"/></xsl:attribute>
      <xsl:attribute name="name"><xsl:value-of select="substring-after(@name,'.')"/></xsl:attribute>

      <!-- Class Description -->
      <xsl:element name="desc">
        <xsl:element name="text">
            <xsl:value-of select="info/description"/>
        </xsl:element>
      </xsl:element> 

      <!-- Constructor -->
      <xsl:if test="method[info/name = '__init__']">
          <xsl:element name="constructor">
            <xsl:for-each select="method[info/name = '__init__']">
                <xsl:call-template name="method"/>
            </xsl:for-each>
          </xsl:element>
      </xsl:if>

      <!-- Properties -->
      <!-- The next would be nice, scanning for 'name=property(...)', but curr. not
           supported in Pythondoc XML
      <xsl:if test="contains(variable/info/def,'property(')">
          <xsl:for-each select="variable[contains(info/def,'property(')]">
            <xsl:call-template name="property">
          </xsl:for-each>
      </xsl:if>
      -->
      <xsl:element name="properties">
        <xsl:apply-templates select="variable"/>
      </xsl:element>

      <!-- Methods -->
      <xsl:element name="methods">
        <xsl:apply-templates select="method[info/name != '__init__']"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>


  <xsl:template match="variable">
      <xsl:element name="property">
          <xsl:attribute name="name"><xsl:value-of select="info/name"/></xsl:attribute>
          <xsl:attribute name="defaultValue"></xsl:attribute>
      </xsl:element>
  </xsl:template>

  <xsl:template match="function">
    <xsl:call-template name="method"/>
  </xsl:template>

  <xsl:template name="method" match="method">
    <xsl:element name="method">
      <xsl:attribute name="hasError">true</xsl:attribute>
      <xsl:if test="info/name='__init__'">
          <xsl:attribute name="isCtor">true</xsl:attribute>
      </xsl:if>
      <xsl:attribute name="name"><xsl:value-of select="info/name"/></xsl:attribute>
	  <!-- description -->
      <xsl:element name="desc">
        <xsl:element name="text"><xsl:value-of select="info/description"/></xsl:element>
      </xsl:element>
	  <!-- @param -->
        <!-- the next is for extracting args from the def tag - curr. not used -->
      <xsl:variable name="arglist"  
                    select="substring-before(substring-after(info/def,'('),')')"/>
      <xsl:element name="params">
        <xsl:apply-templates select="info/param"/>
      </xsl:element>
	  <!-- @return -->
	  <xsl:element name="return">
		  <xsl:element name="desc">
			  <xsl:element name="text">
				  <xsl:value-of select="info/return"/>
			  </xsl:element>
		  </xsl:element>
		  <xsl:element name="types">
			  <xsl:element name="entry">
				  <xsl:attribute name="type"><xsl:value-of select="info/defreturn"/></xsl:attribute>
			  </xsl:element>
		  </xsl:element>
	  </xsl:element>
	  
    </xsl:element>
  </xsl:template>

  <xsl:template match="info/param">
    <xsl:element name="param">
      <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
      <xsl:element name="desc">
        <xsl:element name="text"><xsl:value-of select="."/></xsl:element>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  
</xsl:stylesheet>
