 /**
  * A Tooltip provides additional information for widgets when the user hovers over a widget.
  * This information can consist in plain text, but also include an icon and complex HTML code.
  *
  * *Example*
  *
  * Here is a little example of how to use the widget.
  *
  * <pre class='javascript'>
  * var widget = new qx.ui.form.Button("save");
  *
  * var tooltip = new qx.ui.tooltip.ToolTip("Save the opened file");
  * widget.setToolTip(tooltip);
  * </pre>
  *
  * This example creates a ToolTip and assigns it to a button. When the user hovers the
  * button the tooltip is shown.
  *
  * *External Documentation*
  *
  * <a href='http://manual.qooxdoo.org/1.3/pages/widget/tooltip.html' target='_blank'>
  * Documentation of this widget in the qooxdoo wiki.</a>
  */
