#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a tool for learn to use the mouse
# Copyright (C) 2005-2006 Vincent DEROO (vincent.pysycache@free.fr)
#
# This tool is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#***********************************************************************



#*******************************************************************************
# Importation des modules
#*******************************************************************************
import sys
import getopt, string

import random, os
import pygame
from pygame.locals import *
import const



#*******************************************************************************
#                                                                              #
#                                                                              #
#                                  Fonctions                                   #
#                                                                              #
#                                                                              #
#*******************************************************************************

#*******************************************************************************
# Affiche l'aide
#*******************************************************************************
def help_message():
	print '''
Options: 
    -h                : displays this help message
    -a                : expects an argument
    -nf               : no fullscreen mode
    -ns               : no sound mode  
    --version         : displays Pysycache version
    ---python-version : displays Pysycache version'''
	sys.exit(0)







#*******************************************************************************
# Charge une image de type bmp ou jpeg                                         #
#*******************************************************************************
def load_image(dirname, filename, colorkey=None):
	""" Load bmp or jpeg image and return image object"""
	fullname = os.path.join(const.GRepPysycache, dirname, filename)
	try:
		image = pygame.image.load(fullname)
	except pygame.error, message:
		print 'Cannot load image:', fullname
		raise SystemExit, message

	image = image.convert()
	if colorkey is not None:
		if colorkey is -1:
			colorkey = image.get_at((0,0))
		image.set_colorkey(colorkey, RLEACCEL)

	return image, image.get_rect()




#*******************************************************************************
# Charge une image de type png                                                 #
#*******************************************************************************
def load_png(dirname, filename):
	""" Load png image and return image object"""
	fullname = os.path.join(const.GRepPysycache, dirname, filename)
	try:
		image = pygame.image.load(fullname)
		if image.get_alpha is None:
			image = image.convert()
		else:
			image = image.convert_alpha()
	except pygame.error, message:
		print 'Cannot load image:', fullname
		raise SystemExit, message
	
	return image, image.get_rect()
	
	



#*******************************************************************************
# Play sound                                                                   #
#*******************************************************************************
def load_sound(dirname, filename):
	""" Play sound """
	fullname = os.path.join(const.GRepPysycache, dirname, filename)

	#on joue la musique
	if const.GWithSound == 1:
#		if not pygame.mixer.get_init():
#			print "Cannot load sound : pygame error : ", pygame.get_error()
#		else:
			if os.path.isfile(fullname):
				pygame.mixer.music.load(fullname)
				pygame.mixer.music.play(0)
#			else:
#				print "File ", fullname, " doesn't exist !"
	


#*******************************************************************************
# Play the winner sound
#*******************************************************************************
def PlayWinnerSound():
	idxsnd = random.randint(0, 2)
	if idxsnd == 0 :
		load_sound('sounds', 'youpee.ogg')
	elif idxsnd == 1 :
		load_sound('sounds', 'yahoo.ogg')
	else :
		load_sound('sounds', 'rire.ogg')




#*******************************************************************************
# Make transition between two pictures                                         #
#*******************************************************************************
def ShowTransitionOfTheme(duree, fileimage):
	screen = pygame.display.get_surface()
	
	background_image2, background_rect = load_image('images', fileimage)
	for i in range(267):
		screen.blit(background_image2, (0, i), (0, i, 710, 1))
		screen.blit(background_image2, (0, 534 - i), (0, 534 - i, 710, 1))
		pygame.display.flip()
		pygame.time.wait(duree)
	screen.blit(background_image2, (0,0))
	pygame.display.flip()
