#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
'''
(C) 2008, 2009 Kerim Mansour
For licensing information please refer to license.txt
'''
class CoreAttrib:
    """
    The CoreAttrib class defines the attribute set Core.attrib
    that is the core set of attributes that can be present on any element.
    """
    def set_id(self, id):
        self._attributes['id'] = id
    
    def get_id(self):
        return self._attributes.get('id')
    
    def set_xml_base(self, xml_base):
        self._attributes['xml:base'] = xml_base
    
    def get_xml_base(self):
        return self._attributes.get('xml:base')

    def set_xml_lang(self, language_code):
        self._attributes['xml:lang'] = language_code
    
    def get_xml_lang(self):
        return self._attributes.get('xml:lang')
    
    def set_xml_space(self, xml_space):
        self._attributes['xml:space'] = xml_space
    
    def get_xml_space(self):
        return self._attributes.get('xml:space')

class ConditionalAttrib:
    """
    The ConditionalAttrib class defines the Conditional.attrib attribute set.
    """
    def set_requiredFeatures(self, requiredFeatures):
        self._attributes['requiredFeatures'] = requiredFeatures
    
    def get_requiredFeatures(self):
        return self._attributes.get('requiredFeatures')
    
    def set_requiredExtensions(self, requiredExtensions):
        self._attributes['requiredExtensions'] = requiredExtensions
    
    def get_requiredExtensions(self):
        return self._attributes.get('requiredExtensions')
    
    def set_systemLanguage(self, language_code):
        self._attributes['systemLanguage'] = language_code
    
    def get_systemLanguage(self):
        return self._attributes.get('systemLanguage')

class StyleAttrib:
    """
    The StyleAttrib class defines the Style.attrib attribute set.
    """
    def set_style(self, style):
        self._attributes['style'] = style
    
    def get_style(self):
        return self._attributes.get('style')
    
    def set_class(self, aClass):
        self._attributes['class'] = aClass
    
    def get_class(self):
        return self._attributes.get('class')
    
class GraphicalEventsAttrib:
    """
    The GraphicalEventsAttrib class defines the GraphicalEvents.attrib attribute set.
    """
    def set_onfocusin(self, onfocusin):
        self._attributes['onfocusin'] = onfocusin
    
    def get_onfocusin(self):
        return self._attributes.get('onfocusin')
    
    def set_onfocusout(self, onfocusout):
        self._attributes['onfocusout'] = onfocusout
    
    def get_onfocusout(self):
        return self._attributes.get('onfocusout')
    
    def set_onactivate(self, onactivate):
        self._attributes['onactivate'] = onactivate
    
    def get_onactivate(self):
        return self._attributes.get('onactivate')
    
    def set_onclick(self, onclick):
        self._attributes['onclick'] = onclick
    
    def get_onclick(self):
        return self._attributes.get('onclick')
    
    def set_onmousedown(self, onmousedown):
        self._attributes['onmousedown'] = onmousedown
    
    def get_onmousedown(self):
        return self._attributes.get('onmousedown')
    
    def set_onmouseup(self, onmouseup):
        self._attributes['onmouseup'] = onmouseup
    
    def get_onmouseup(self):
        return self._attributes.get('onmouseup')
    
    def set_onmouseover(self, onmouseover):
        self._attributes['onmouseover'] = onmouseover
    
    def get_onmouseover(self):
        return self._attributes.get('onmouseover')
    
    def set_onmousemove(self, onmousemove):
        self._attributes['onmousemove'] = onmousemove
    
    def get_onmousemove(self):
        return self._attributes.get('onmousemove')
    
    def set_onmouseout(self, onmouseout):
        self._attributes['onmouseout'] = onmouseout
    
    def get_onmouseout(self):
        return self._attributes.get('onmouseout')
    
    def set_onload(self, onload):
        self._attributes['onload'] = onload
    
    def get_onload(self):
        return self._attributes.get('onload')


    
class CursorAttrib:
    """
    The CursorAttrib class defines the Cursor.attrib attribute set.
    """   
    def set_cursor(self, cursor):
        self._attributes['cursor'] = cursor
    
    def get_cursor(self):
        return self._attributes.get('cursor')
    
class ExternalAttrib:
    """
    The ExternalAttrib class defines the External.attrib attribute set.
    """
    def set_externalResourcesRequired(self, externalResourcesRequired):
        self._attributes['externalResourcesRequired'] = externalResourcesRequired
    
    def get_externalResourcesRequired(self):
        return self._attributes.get('externalResourcesRequired')

class DocumentEventsAttrib:
    """
    The DocumentEventsAttrib class defines the DocumentEvents.attrib attribute set.
    """
    def set_onunload(self, onunload):
        self._attributes['onunload'] = onunload
    
    def get_onunload(self):
        return self._attributes.get('onunload')
    
    def set_onabort(self, onabort):
        self._attributes['onabort'] = onabort
    
    def get_onabort(self):
        return self._attributes.get('onabort')
    
    def set_onerror(self, onerror):
        self._attributes['onerror'] = onerror
    
    def get_onerror(self):
        return self._attributes.get('onerror')
    
    def set_onresize(self, onresize):
        self._attributes['onresize'] = onresize
    
    def get_onresize(self):
        return self._attributes.get('onresize')
    
    def set_onscroll(self, onscroll):
        self._attributes['onscroll'] = onscroll
    
    def get_onscroll(self):
        return self._attributes.get('onscroll')
    
    def set_onzoom(self, onzoom):
        self._attributes['onzoom'] = onzoom
    
    def get_onzoom(self):
        return self._attributes.get('onzoom')

class OpacityAttrib:
    """
    The OpacityAttrib class defines the Opacity.attrib attribute set.
    """
    def set_opacity(self, opacity):
        self._attributes['opacity'] = opacity
    
    def get_opacity(self):
        return self._attributes.get('opacity')
    
    def set_stroke_opacity(self, stroke_opacity):
        self._attributes['stroke-opacity'] = stroke_opacity
    
    def get_stroke_opacity(self):
        return self._attributes.get('stroke-opacity')
    
    def set_fill_opacity(self, fill_opacity):
        self._attributes['fill-opacity'] = fill_opacity
    
    def get_fill_opacity(self):
        return self._attributes.get('fill-opacity')

class PaintAttrib:
    """
    The PaintAttrib class defines the Paint.attrib attribute set.
    """
    def set_color(self, color):
        self._attributes['color'] = color
    
    def get_color(self):
        return self._attributes.get('color')
    
    def set_color_interpolation(self, color_interpolation):
        self._attributes['color-interpolation'] = color_interpolation
    
    def get_color_interpolation(self):
        return self._attributes.get('color-interpolation')
    
    def set_color_rendering(self, color_rendering):
        self._attributes['color-rendering'] = color_rendering
    
    def get_color_rendering(self):
        return self._attributes.get('color-rendering')
    
    def set_fill(self, fill):
        self._attributes['fill'] = fill
    
    def get_fill(self):
        return self._attributes.get('fill')
    
    def set_fill_rule(self, fill_rule):
        self._attributes['fill-rule'] = fill_rule
    
    def get_fill_rule(self):
        return self._attributes.get('fill-rule')
    
    def set_stroke(self, stroke):
        self._attributes['stroke'] = stroke
    
    def get_stroke(self):
        return self._attributes.get('stroke')
    
    def set_stroke_dasharray(self, stroke_dasharray):
        self._attributes['stroke-dasharray'] = stroke_dasharray
    
    def get_stroke_dasharray(self):
        return self._attributes.get('stroke-dasharray')
    
    def set_stroke_dashoffset(self, stroke_dashoffset):
        self._attributes['stroke-dashoffset'] = stroke_dashoffset
    
    def get_stroke_dashoffset(self):
        return self._attributes.get('stroke-offset')
    
    def set_stroke_linecap(self, stroke_linecap):
        self._attributes['stroke-linecap'] = stroke_linecap
    
    def get_stroke_linecap(self):
        return self._attributes.get('stroke-linecap')
    
    def set_stroke_linejoin(self, stroke_linejoin):
        self._attributes['stroke-linejoin'] = stroke_linejoin
    
    def get_stroke_linejoin(self):
        return self._attributes.get('stroke-linejoin')
    
    def set_stroke_miterlimit(self, stroke_miterlimit):
        self._attributes['stroke-miterlimit'] = stroke_miterlimit
    
    def get_stroke_miterlimit(self):
        return self._attributes.get('stroke-miterlimit')
    
    def set_stroke_width(self, stroke_width):
        self._attributes['stroke-width'] = stroke_width
    
    def get_stroke_width(self):
        return self._attributes.get('stroke-width')
    
class GraphicsAttrib:
    """
    The GraphicsAttrib class defines the Graphics.attrib attribute set.
    """
    def set_display(self, display):
        self._attributes['display'] = display
    
    def get_display(self):
        return self._attributes.get('display')
    
    def set_image_rendering(self, image_rendering):
        self._attributes['image-rendering'] = image_rendering
    
    def get_image_rendering(self):
        return self._attributes.get('image-rendering')
    
    def set_pointer_events(self, pointer_events):
        self._attributes['pointer-events'] = pointer_events
    
    def get_pointer_events(self):
        return self._attributes.get('pointer-events')
    
    def set_shape_rendering(self, shape_rendering):
        self._attributes['shape-rendering'] = shape_rendering
    
    def get_shape_rendering(self):
        return self._attributes.get('shape-rendering')
    
    def set_text_rendering(self, text_rendering):
        self._attributes['text-rendering'] = text_rendering
    
    def get_text_rendering(self):
        return self._attributes.get('text-rendering')
    
    def set_visibility(self, visibility):
        self._attributes['visibility'] = visibility
    
    def get_visibility(self):
        return self._attributes.get('visibility')

class MarkerAttrib:
    """
    The MarkerAttrib class defines the Marker.attrib attribute set.
    """
    def set_marker_start(self, marker_start):
        self._attributes['marker-start'] = marker_start
    
    def get_marker_start(self):
        return self._attributes.get('marker-start')
    
    def set_marker_mid(self, marker_mid):
        self._attributes['marker-mid'] = marker_mid
    
    def get_marker_mid(self):
        return self._attributes.get('marker-mid')
    
    def set_marker_end(self, marker_end):
        self._attributes['marker-end'] = marker_end
    
    def get_marker_end(self):
        return self._attributes.get('marker-end')
    
class ViewportAttrib:
    """
    The ViewportAttrib class defines the Viewport.attrib attribute set.
    """
    def set_clip(self, clip):
        self._attributes['clip'] = clip
    
    def get_clip(self):
        return self._attributes.get('clip')
    
    def set_overflow(self, overflow):
        self._attributes['overflow'] = overflow
    
    def get_overflow(self):
        return self._attributes.get('overflow')

class FilterAttrib:
    """
    The FilterAttrib class defines the Filter.attrib attribute sets.
    """
    def set_filter(self, filter):
        self._attributes['filter'] = filter
    
    def get_filter(self):
        return self._attributes.get('filter')

class FilterColorAttrib:
    """
    The FilterColorAttrib class defines the FilterColor.attrib attribute sets.
    """
    def set_color_interpolation_filters(self, color_interpolation_filters):
        self._attributes['color-interpolation-filters'] = color_interpolation_filters
    
    def get_color_interpolation_filters(self):
        return self._attributes.get('color-interpolation-filters')
    
class FilterPrimitiveAttrib:
    """
    The FilterPrimitiveAttrib class defines the FilterPrimitive.attrib attribute sets.
    """
    def set_x(self, x):
        self._attributes['x'] = x
    
    def get_x(self):
        return self._attributes.get('x')
    
    def set_y(self, y):
        self._attributes['y'] = y
    
    def get_y(self):
        return self._attributes.get('y')
    
    def set_height(self, height):
        self._attributes['height'] = height
    
    def get_height(self):
        return self._attributes.get('height')
    
    def set_width(self, width):
        self._attributes['width'] = width
    
    def get_width(self):
        return self._attributes.get('width')
    
    def set_result(self, result):
        self._attributes['result'] = result
    
    def get_result(self):
        return self._attributes.get('result')    

class FilterPrimitiveWithInAttrib(FilterPrimitiveAttrib):
    """
    The FilterPrimitiveWithInAttrib class defines the FilterPrimitiveWithIn.attrib attribute sets.
    """
    def set_in(self, inValue):
        self._attributes['in'] = inValue
    
    def get_in(self):
        return self._attributes.get('in')
    
class XLinkAttrib:
    """
    The XLinkAttrib class defines the XLink.attrib, XLinkRequired.attrib, XLinkEmbed.attrib and XLinkReplace.attrib attribute sets.
    """
    def set_xlink_type(self, xlink_type):
        self._attributes['xlink:type'] = xlink_type
    def get_xlink_type(self):
        return self.attributes['xlink:type']
    
    def set_xlink_href(self, xlink_href):
        self._attributes['xlink:href'] = xlink_href
    def get_xlink_href(self):
        return self.attributes['xlink:href']
    
    def set_xlink_role(self, xlink_role):
        self._attributes['xlink:role'] = xlink_role
    def get_xlink_role(self):
        return self.attributes['xlink:role']
    
    def set_xlink_arcrole(self, xlink_arcrole):
        self._attributes['xlink:arcrole'] = xlink_arcrole
    def get_xlink_arcrole(self):
        return self.attributes['xlink:arcrole']
    
    def set_xlink_title(self, xlink_title):
        self._attributes['xlink:title'] = xlink_title
    def get_xlink_title(self):
        return self.attributes['xlink:title']
    
    def set_xlink_show(self, xlink_show):
        self._attributes['xlink:show'] = xlink_show
    def get_xlink_show(self):
        return self.attributes['xlink:show']
    
    def set_xlink_actuate(self, xlink_actuate):
        self._attributes['xlink:actuate'] = xlink_actuate
    def get_xlink_actuate(self):
        return self.attributes['xlink:actuate']

class TextAttrib:
    """
    The TextAttrib class defines the Text.attrib attribute set.
    """
    def set_writing_mode(self, writing_mode):
        self._attributes['writing-mode'] = writing_mode
    def get_writing_mode(self):
        return self.attributes['writing-mode']

class TextContentAttrib:
    """
    The TextContentAttrib class defines the TextContent.attrib attribute set.
    """
    def set_alignment_baseline(self, alignment_baseline):
        self._attributes['alignment-baseline'] = alignment_baseline
    def get_alignment_baseline(self):
        return self.attributes['alignment-baseline']
    
    def set_baseline_shift(self, baseline_shift):
        self._attributes['baseline-shift'] = baseline_shift
    def get_baseline_shift(self):
        return self.attributes['baseline-shift']
    
    def set_direction(self, direction):
        self._attributes['direction'] = direction
    def get_direction(self):
        return self.attributes['direction']
    
    def set_dominant_baseline(self, dominant_baseline):
        self._attributes['dominant-baseline'] = dominant_baseline
    def get_dominant_baseline(self):
        return self.attributes['dominant-baseline']
    
    def set_glyph_orientation_horizontal(self, glyph_orientation_horizontal):
        self._attributes['glyph-orientation-horizontal'] = glyph_orientation_horizontal
    def get_glyph_orientation_horizontal(self):
        return self.attributes['glyph-orientation-horizontal']
    
    def set_glyph_orientation_vertical(self, glyph_orientation_vertical):
        self._attributes['glyph-orientation-vertical'] = glyph_orientation_vertical
    def get_glyph_orientation_vertical(self):
        return self.attributes['glyph-orientation-vertical']
    
    def set_kerning(self, kerning):
        self._attributes['kerning'] = kerning
    def get_kerning(self):
        return self.attributes['kerning']
    
    def set_letter_spacing(self, letter_spacing):
        self._attributes['letter-spacing'] = letter_spacing
    def get_letter_spacing(self):
        return self.attributes['letter-spacing']
    
    def set_text_anchor(self, text_anchor):
        self._attributes['text-anchor'] = text_anchor
    def get_text_anchor(self):
        return self.attributes['text-anchor']
    
    def set_text_decoration(self, text_decoration):
        self._attributes['text-decoration'] = text_decoration
    def get_text_decoration(self):
        return self.attributes['text-decoration']
    
    def set_unicode_bidi(self, unicode_bidi):
        self._attributes['unicode-bidi'] = unicode_bidi
    def get_unicode_bidi(self):
        return self.attributes['unicode-bidi']
    
    def set_word_spacing(self, word_spacing):
        self._attributes['word-spacing'] = word_spacing
    def get_word_spacing(self):
        return self.attributes['word-spacing']

class FontAttrib:
    """
    The FontAttrib class defines the Font.attrib attribute set.
    """
    def set_font_family(self, font_family):
        self._attributes['font-family'] = font_family
    def get_font_family(self):
        return self.attributes['font-family']
    
    def set_font_size(self, font_size):
        self._attributes['font-size'] = font_size
    def get_font_size(self):
        return self.attributes['font-size']
    
    def set_font_size_adjust(self, font_size_adjust):
        self._attributes['font-size-adjust'] = font_size_adjust
    def get_font_size_adjust(self):
        return self.attributes['font-size-adjust']
    
    def set_font_stretch(self, font_stretch):
        self._attributes['font-stretch'] = font_stretch
    def get_font_stretch(self):
        return self.attributes['font-stretch']
    
    def set_font_style(self, font_style):
        self._attributes['font-style'] = font_style
    def get_font_style(self):
        return self.attributes['font-style']
    
    def set_font_variant(self, font_variant):
        self._attributes['font-variant'] = font_variant
    def get_font_variant(self):
        return self.attributes['font-variant']
    
    def set_font_weight(self, font_weight):
        self._attributes['font-weight'] = font_weight
    def get_font_weight(self):
        return self.attributes['font-weight']
    
class MaskAttrib:
    """
    The MaskAttrib class defines the Mask.attrib attribute set.
    """
    def set_mask(self, mask):
        self._attributes['mask'] = mask
    
    def get_mask(self):
        return self._attributes.get('mask')

class ClipAttrib:
    """
    The ClipAttrib class defines the Clip.attrib attribute set.
    """
    def set_clip_path(self, clip_path):
        self._attributes['clip-path'] = clip_path
    
    def get_clip_path(self):
        return self._attributes.get('clip-path')
    
    def set_clip_rule(self, clip_rule):
        self._attributes['clip-rule'] = clip_rule
    
    def get_clip_rule(self):
        return self._attributes.get('clip-rule')

class GradientAttrib:
    """
    The GradientAttrib class defines the Gradient.attrib attribute set.
    """
    def set_stop_color(self, stop_color):
        self._attributes['stop-color'] = stop_color
    
    def get_stop_color(self):
        return self._attributes.get('stop-color')
    
    def set_stop_opacity(self, stop_opacity):
        self._attributes['stop-opacity'] = stop_opacity
    
    def get_stop_opacity(self):
        return self._attributes.get('stop-opacity')

class PresentationAttributes_Color:
    """
    The PresentationAttributes_Color class defines the PresentationAttributes_Color.attrib attribute set.
    The following presentation attributes have to do with specifying color.
    """
    def set_color(self, color):
        self._attributes['color'] = color
    
    def get_color(self):
        return self._attributes.get('color')
    
    def set_color_interpolation(self, color_interpolation):
        self._attributes['color-interpolation'] = color_interpolation
    
    def get_color_interpolation(self):
        return self._attributes.get('color-interpolation')
    
    def set_color_rendering(self, color_rendering):
        self._attributes['color-rendering'] = color_rendering
    
    def get_color_rendering(self):
        return self._attributes.get('color-rendering')

class PresentationAttributes_Containers:
    """
    The PresentationAttributes_Containers class defines the PresentationAttributes_Containers.attrib attribute set.
    The following presentation attributes apply to container elements.
    """
    def set_enable_background(self, enableBackground):
        self._attributes['enable-background'] = enableBackground
    
    def get_enable_background(self):
        return self._attributes.get('enable-background')

class PresentationAttributes_feFlood:
    """
    The PresentationAttributes_feFlood class defines the PresentationAttributes_feFlood.attrib attribute set.
    The following presentation attributes apply to 'feFlood' elements.
    """
    def set_flood_color(self, flood_color):
        self._attributes['flood-color'] = flood_color
    def get_flood_color(self):
        return self._attributes.get('flood-color')
    
    def set_flood_opacity(self, flood_opacity):
        self._attributes['flood-opacity'] = flood_opacity
    def get_flood_opacity(self):
        return self._attributes.get('flood-opacity')

class PresentationAttributes_FilterPrimitives:
    """
    The PresentationAttributes_FilterPrimitives class defines the PresentationAttributes_FilterPrimitives.attrib attribute set.
    The following presentation attributes apply to filter primitives
    """
    def set_color_interpolation_filters(self, color_interpolation_filters):
        self._attributes['color-interpolation-filters'] = color_interpolation_filters
    def get_color_interpolation_filters(self):
        return self._attributes.get('color-interpolation-filters')
    
class PresentationAttributes_FillStroke:
    """
    The PresentationAttributes_FillStroke class defines the PresentationAttributes_FillStroke.attrib attribute set.
    The following presentation attributes apply to filling and stroking operations.
    """
    def set_fill(self, fill):
        self._attributes['fill'] = fill
    
    def get_fill(self):
        return self._attributes.get('fill')
    
    def set_fill_opacity(self, fill_opacity):
        self._attributes['fill-opacity'] = fill_opacity
    
    def get_fill_opacity(self):
        return self._attributes.get('fill-opacity')
    
    def set_fill_rule(self, fill_rule):
        self._attributes['fill-rule'] = fill_rule
    
    def get_fill_rule(self):
        return self._attributes.get('fill-rule')
    
    def set_stroke(self, stroke):
        self._attributes['stroke'] = stroke
    
    def get_stroke(self):
        return self._attributes.get('stroke')
    
    def set_stroke_opacity(self, stroke_opacity):
        self._attributes['stroke-opacity'] = stroke_opacity
    
    def get_stroke_opacity(self):
        return self._attributes.get('stroke-opacity')
    
    def set_stroke_dasharray(self, stroke_dasharray):
        self._attributes['stroke-dasharray'] = stroke_dasharray
    
    def get_stroke_dasharray(self):
        return self._attributes.get('stroke-dasharray')
    
    def set_stroke_dashoffset(self, stroke_dashoffset):
        self._attributes['stroke-dashoffset'] = stroke_dashoffset
    
    def get_stroke_dashoffset(self):
        return self._attributes.get('stroke-offset')
    
    def set_stroke_linecap(self, stroke_linecap):
        self._attributes['stroke-linecap'] = stroke_linecap
    
    def get_stroke_linecap(self):
        return self._attributes.get('stroke-linecap')
    
    def set_stroke_linejoin(self, stroke_linejoin):
        self._attributes['stroke-linejoin'] = stroke_linejoin
    
    def get_stroke_linejoin(self):
        return self._attributes.get('stroke-linejoin')
    
    def set_stroke_miterlimit(self, stroke_miterlimit):
        self._attributes['stroke-miterlimit'] = stroke_miterlimit
    
    def get_stroke_miterlimit(self):
        return self._attributes.get('stroke-miterlimit')
    
    def set_stroke_width(self, stroke_width):
        self._attributes['stroke-width'] = stroke_width
    
    def get_stroke_width(self):
        return self._attributes.get('stroke-width')

class PresentationAttributes_FontSpecification(FontAttrib):
    """
    The PresentationAttributes_FontSpecification class defines the PresentationAttributes_FontSpecification.attrib attribute set.
    The following presentation attributes have to do with selecting a font to use.
    """

class PresentationAttributes_Gradients(GradientAttrib):
    """
    The PresentationAttributes_Gradients class defines the PresentationAttributes_Gradients.attrib attribute set.
    The following presentation attributes apply to gradient 'stop' elements.
    """

class PresentationAttributes_Graphics(ClipAttrib, CursorAttrib, GraphicsAttrib, MaskAttrib, FilterAttrib):
    """
    The PresentationAttributes_Graphics class defines the PresentationAttributes_Graphics.attrib attribute set.
    The following presentation attributes apply to graphics elements
    """   
    def set_opacity(self, opacity):
        self._attributes['opacity'] = opacity
    
    def get_opacity(self):
        return self._attributes.get('opacity')
  
class PresentationAttributes_Images:
    """
    The PresentationAttributes_Images class defines the PresentationAttributes_Images.attrib attribute set.
    The following presentation attributes apply to 'image' elements
    """
    def set_color_profile(self, color_profile):
        self._attributes['color-profile'] = color_profile
    
    def get_color_profile(self):
        return self._attributes.get('color-profile')

class PresentationAttributes_LightingEffects:
    """
    The PresentationAttributes_LightingEffects class defines the PresentationAttributes_LightingEffects.attrib attribute set.
    The following presentation attributes apply to 'feDiffuseLighting' and 'feSpecularLighting' elements
    """
    def set_lighting_color(self, lighting_color):
        self._attributes['lighting-color'] = lighting_color
    def get_lighting_color(self):
        return self._attributes.get('lighting-color')

class PresentationAttributes_Marker(MarkerAttrib):
    """
    The PresentationAttributes_Marker class defines the PresentationAttributes_Marker.attrib attribute set.
    The following presentation attributes apply to marker operations
    """

class PresentationAttributes_TextContentElements(TextContentAttrib):
    """
    The PresentationAttributes_TextContentElements class defines the PresentationAttributes_TextContentElements.attrib attribute set.
    The following presentation attributes apply to text content elements
    """

class PresentationAttributes_TextElements(TextAttrib):
    """
    The following presentation attributes apply to 'text' elements
    """  

class PresentationAttributes_Viewports(ViewportAttrib):
    """
    The following presentation attributes apply to elements that establish viewports
    """  

class PresentationAttributes_All(PresentationAttributes_Color, PresentationAttributes_Containers, PresentationAttributes_feFlood, PresentationAttributes_FillStroke, PresentationAttributes_FilterPrimitives, PresentationAttributes_FontSpecification, PresentationAttributes_Gradients, PresentationAttributes_Graphics, PresentationAttributes_Images, PresentationAttributes_LightingEffects, PresentationAttributes_Marker, PresentationAttributes_TextContentElements, PresentationAttributes_TextElements, PresentationAttributes_Viewports):
    """
    The PresentationAttributes_All class defines the Presentation.attrib attribute set.
    """
    

class ColorAttrib:
    """
    The ColorAttrib class defines the Color.attrib attribute set.
    """
    

