
{ Turbo Sliders }
{ Copyright (c) 1989 by Borland International, Inc. }

Unit Sliders;
{ Turbo Pascal 5.5 object-oriented example.
  This unit extends FORM.PAS' Field object type.
  Refer to OOPDEMOS.DOC for an overview of this unit.
}

{$S-}

Interface

Uses Forms;

Type
  
  FSliderPtr = ^FSlider;
  FSlider = Object (Field)
              Min, Max, Delta: Integer;
              Constructor Init (PX, PY: Integer; PTitle: FString;
              PMin, PMax, PDelta: Integer);
              Procedure Clear; Virtual;
              Function Edit: Char; Virtual;
              Procedure Show; Virtual;
              Procedure Display (I: Integer);
            End;
  
  FStream = Object (Forms. FStream)
              Procedure RegisterTypes; Virtual;
            End;
  
Implementation

Uses Crt;

{ FSlider }

Constructor FSlider. Init (PX, PY: Integer; PTitle: FString;
  PMin, PMax, PDelta: Integer);
Begin
  Field. Init (PX, PY, 2, PTitle);
  Min := PMin;
  Max := PMax;
  Delta := PDelta;
End;

Procedure FSlider. Clear;
Begin
  Integer (Value^) := (Max - Min) Div 2;
End;

Function FSlider. Edit: Char;
Var
  I: Integer;
  CH: Char;
  Stop: Boolean;
Begin
  I := Integer (Value^);
  Stop := False;
  Repeat
    Display (I);
    GotoXY (X + Length (Title^) + 1, Y);
    CH := ReadChar;
    Case CH Of
      CLeft: If I > Min Then Dec (I, Delta);
      CRight: If I < Max Then Inc (I, Delta);
      CHome: I := Min;
      CEnd: I := Max;
      CUndo: I := Integer (Value^);
      CEnter, CNext, CPrev, CSave, CEsc: Stop := True;
      Else
        Beep;
    End;
  Until Stop;
  If CH <> CEsc Then Integer (Value^) := I;
  Edit := CH;
End;

Procedure FSlider. Show;
Begin
  Display (Integer (Value^) );
End;

Procedure FSlider. Display (I: Integer);
Var
  Steps: Integer;
  S: FString;
Begin
  Steps := (Max - Min) Div Delta + 1;
  S [0] := Chr (Steps);
  FillChar (S [1], Steps, #176);
  S [ (I - Min) Div Delta + 1] := #219;
  GotoXY (X, Y);
  Color (TitleColor);
  Write (Title^);
  Color (ValueColor);
  Write (' ', Min, ' ', S, ' ', Max, ' ');
End;

{ FStream }

Procedure FStream. RegisterTypes;
Begin
  Forms. FStream. RegisterTypes;
  Register (TypeOf (FSlider), @FSlider. Store, @FSlider. Load);
End;

End.
