Unit pupo;


Interface

Uses crt, DOS, Input;

Const
  ablakelo : Byte = White;
  ablakhat : Byte = Blue;
  ablakero : Byte = 0;
  ablakszov: String = '';
  ablakmenu: String = '';
  
Procedure pushw (X, Y, xm, ym: Byte);   { left up cornel and size }
Procedure popw;
Procedure initpupo;
Procedure ablak (X, Y, hx, hy, tip: Byte);

Implementation

Const
  maxpush = 20;                                   { max 8 window }
  MaxLines = 43;
  
Type vector = Array [1..3000] Of Word;
  ScreenType = Array [1..MaxLines, 1..80] Of Word;
  ScreenPtr = ^ScreenType;
Var
  pp         : Array [1..maxpush] Of Pointer;
  pmut       : 0..maxpush;
  DisplayPtr : ScreenPtr;
  colorcard  : Boolean;
  txtatr     : Array [0..maxpush] Of Byte;
  
  
Procedure InitDisplay;
Var
  Reg : Registers;
Begin
  Reg. AH := 15;
  Intr ($10, Reg);
  ColorCard := Reg. AL <> 7;
  If ColorCard Then
    DisplayPtr := Ptr ($B800, 0)
  Else
    DisplayPtr := Ptr ($B000, 0);
End;

Procedure pushw (X, Y, xm, ym: Byte);   { left up cornel and size }
Var pv:^vector;
  i, j, k: Integer;
Begin
  Inc (pmut);
  If pmut > maxpush Then Begin Write ('too many push'); Halt; End;
  txtatr [pmut] := TextAttr;
  szin (ablakelo, ablakhat, ablakero);
  If pmut > 5 Then Exit;
  i := xm * ym * 2;
  GetMem (pp [pmut], i + 8);
  pv := pp [pmut];
  pv^ [1] := X;
  pv^ [2] := Y;
  pv^ [3] := xm;
  pv^ [4] := ym;
  k := 4;
  For i := X To X + xm - 1 Do
    For j := Y To Y + ym - 1 Do Begin
      Inc (k);
      pv^ [k] := displayptr^ [j, i];
      displayptr^ [j, i] := TextAttr * 16 * 16 + Ord (' ');
    End;
  GotoXY (X, Y);
End;

Procedure popw;
Var pv:^vector;
  X, Y, xm, ym: Byte;
  i, j, k: Integer;
Begin
  If pmut < 1 Then Exit;
  pv := pp [pmut];
  X := pv^ [1];
  Y := pv^ [2];
  xm := pv^ [3];
  ym := pv^ [4];
  k := 4;
  For i := X To X + xm - 1 Do
    For j := Y To Y + ym - 1 Do Begin
      Inc (k);
      displayptr^ [j, i] := pv^ [k];
    End;
  i := xm * ym * 2;
  FreeMem (pp [pmut], i + 8);
  TextAttr := txtatr [pmut];
  Dec (pmut);
  
End;

Procedure initpupo;
Begin
  While pmut > 0 Do popw;
End;

Procedure ablak (X, Y, hx, hy, tip: Byte);
Var txtatr: Byte;
Begin
  pushw (X, Y, hx, hy);
  keret (X, Y, X + hx - 1, Y + hy - 1, tip);
  GotoXY (X + (hx - Length (ablakszov) ) Div 2, Y);
  Write (ablakszov);
  ablakszov := '';
  GotoXY (X + hx - Length (ablakmenu) - 1, Y + hy - 1);
  Write (ablakmenu);
  ablakmenu := '';
  GotoXY (X + 1, Y + 1);
End;

Begin
  pmut := 0;
  InitDisplay;
End.
