/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.jpeg;

import java.io.File;
import javax.swing.JOptionPane;
import tim.prune.I18nManager;
import tim.prune.jpeg.ExifLibrary;
import tim.prune.jpeg.JpegData;

public abstract class ExifGateway {
    private static ExifLibrary _exifLibrary = null;
    private static boolean _exifFailWarned = false;

    static {
        String string = "InternalExifLibrary";
        try {
            _exifLibrary = (ExifLibrary)Class.forName("tim.prune.jpeg." + string).newInstance();
        }
        catch (Throwable throwable) {
            _exifLibrary = null;
        }
    }

    public static JpegData getJpegData(File file) {
        try {
            if (_exifLibrary != null) {
                JpegData jpegData = _exifLibrary.getJpegData(file);
                return jpegData;
            }
        }
        catch (LinkageError linkageError) {}
        if (!_exifFailWarned) {
            JOptionPane.showMessageDialog(null, I18nManager.getText("error.jpegload.exifreadfailed"), I18nManager.getText("error.jpegload.dialogtitle"), 2);
            _exifFailWarned = true;
        }
        return null;
    }

    public static String getDescriptionKey() {
        String string = "internal";
        if (_exifLibrary == null || !_exifLibrary.looksOK()) {
            string = String.valueOf(string) + ".failed";
        }
        return string;
    }
}

