/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.profile;

import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Track;
import tim.prune.gui.profile.ProfileData;

public class SpeedData
extends ProfileData {
    private boolean _metric = true;

    public SpeedData(Track track) {
        super(track);
    }

    public void init() {
        this.initArrays();
        this._metric = Config.getConfigBoolean("prune.metricunits");
        this._hasData = false;
        this._maxValue = 0.0;
        this._minValue = 0.0;
        if (this._track != null) {
            DataPoint dataPoint = null;
            DataPoint dataPoint2 = null;
            DataPoint dataPoint3 = null;
            int n = 0;
            while (n < this._track.getNumPoints()) {
                double d;
                dataPoint3 = this._track.getPoint(n);
                if (dataPoint != null && dataPoint.hasTimestamp() && dataPoint2 != null && dataPoint2.hasTimestamp() && dataPoint3 != null && dataPoint3.hasTimestamp() && (d = (double)dataPoint3.getTimestamp().getSecondsSince(dataPoint.getTimestamp())) > 0.0) {
                    double d2;
                    double d3 = DataPoint.calculateRadiansBetween(dataPoint, dataPoint2) + DataPoint.calculateRadiansBetween(dataPoint2, dataPoint3);
                    double d4 = Distance.convertRadiansToDistance(d3, this._metric ? Distance.Units.KILOMETRES : Distance.Units.MILES);
                    this._pointValues[n - 1] = d2 = d4 / d * 60.0 * 60.0;
                    if (d2 < this._minValue || this._minValue == 0.0) {
                        this._minValue = d2;
                    }
                    if (d2 > this._maxValue) {
                        this._maxValue = d2;
                    }
                    this._hasData = true;
                    this._pointHasData[n - 1] = true;
                }
                dataPoint = dataPoint2;
                dataPoint2 = dataPoint3;
                ++n;
            }
        }
    }

    public String getLabel() {
        return String.valueOf(I18nManager.getText("fieldname.speed")) + " (" + I18nManager.getText(this._metric ? "units.kmh" : "units.mph") + ")";
    }

    public String getNoDataKey() {
        return "display.notimestamps";
    }
}

