/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourScheme;
import tim.prune.config.Config;
import tim.prune.gui.ColourChooser;
import tim.prune.gui.ColourPatch;

public class SetColours
extends GenericFunction {
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private ColourPatch[] _patches = null;
    private ColourChooser _colourChooser = null;
    private static final String[] LABEL_KEYS = new String[]{"background", "primary", "point", "secondary", "selection", "borders", "text", "lines"};
    private static final int[] INDICES;

    static {
        int[] nArray = new int[8];
        nArray[1] = 4;
        nArray[2] = 1;
        nArray[3] = 5;
        nArray[4] = 2;
        nArray[5] = 6;
        nArray[6] = 3;
        nArray[7] = 7;
        INDICES = nArray;
    }

    public SetColours(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setcolours";
    }

    private Component makeContents() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.setcolours.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout());
        this._patches = new ColourPatch[8];
        ColourScheme colourScheme = Config.getColourScheme();
        ColourPatch colourPatch = null;
        int n = 0;
        while (n < 4) {
            jComponent = new JPanel();
            jComponent.setLayout(new BoxLayout(jComponent, 1));
            jComponent.add(new JLabel(I18nManager.getText("dialog.setcolours." + LABEL_KEYS[n * 2])));
            colourPatch = new ColourPatch(colourScheme.getColour(INDICES[n * 2]));
            colourPatch.addMouseListener(new PatchListener(colourPatch));
            jComponent.add(colourPatch);
            this._patches[n * 2] = colourPatch;
            jComponent.add(Box.createRigidArea(new Dimension(0, 5)));
            jComponent.add(new JLabel(I18nManager.getText("dialog.setcolours." + LABEL_KEYS[n * 2 + 1])));
            colourPatch = new ColourPatch(colourScheme.getColour(INDICES[n * 2 + 1]));
            colourPatch.addMouseListener(new PatchListener(colourPatch));
            jComponent.add(colourPatch);
            this._patches[n * 2 + 1] = colourPatch;
            jComponent.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jPanel2.add(jComponent);
            ++n;
        }
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetColours.this.updateConfigColours();
                SetColours.this._dialog.dispose();
            }
        });
        jComponent = new JButton(I18nManager.getText("button.cancel"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetColours.this._dialog.dispose();
            }
        });
        JButton jButton = new JButton(I18nManager.getText("button.resettodefaults"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = 0;
                while (n < 8) {
                    SetColours.this._patches[n].setColour(ColourScheme.getDefaultColour(INDICES[n]));
                    ++n;
                }
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(this._okButton);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jComponent);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog((Frame)this._parentFrame, I18nManager.getText(this.getNameKey()));
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeContents());
            this._dialog.pack();
            this._colourChooser = new ColourChooser(this._dialog);
        }
        ColourScheme colourScheme = Config.getColourScheme();
        int n = 0;
        while (n < 8) {
            this._patches[n].setColour(colourScheme.getColour(INDICES[n]));
            ++n;
        }
        this._dialog.setVisible(true);
        this._okButton.requestFocus();
    }

    private void updateConfigColours() {
        ColourScheme colourScheme = Config.getColourScheme();
        int n = 0;
        while (n < this._patches.length) {
            colourScheme.setColour(INDICES[n], this._patches[n].getBackground());
            ++n;
        }
        Config.updateColourScheme();
        UpdateMessageBroker.informSubscribers();
    }

    class PatchListener
    extends MouseAdapter {
        private ColourPatch _patch = null;

        public PatchListener(ColourPatch colourPatch) {
            this._patch = colourPatch;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            SetColours.this._colourChooser.showDialog(this._patch.getBackground());
            Color color = SetColours.this._colourChooser.getChosenColour();
            if (color != null) {
                this._patch.setColour(color);
            }
        }
    }
}

