/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tim.prune.data.TimeDifference;

public class Timestamp {
    private boolean _valid;
    private long _seconds;
    private String _text;
    private String _timeText;
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final DateFormat DEFAULT_TIME_FORMAT = DateFormat.getTimeInstance();
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DateFormat ISO_8601_FORMAT_NOZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static DateFormat[] ALL_DATE_FORMATS = null;
    private static Calendar CALENDAR = null;
    private static final Pattern GENERAL_TIMESTAMP_PATTERN = Pattern.compile("(\\d{4})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})\\D(\\d{2})");
    private static Matcher GENERAL_TIMESTAMP_MATCHER = null;
    private static long SECS_SINCE_1970 = 0L;
    private static long SECS_SINCE_GARTRIP = 0L;
    private static long MSECS_SINCE_1970 = 0L;
    private static long MSECS_SINCE_1990 = 0L;
    private static long TWENTY_YEARS_IN_SECS = 0L;
    private static final long GARTRIP_OFFSET = 631065600L;
    public static final int FORMAT_ORIGINAL = 0;
    public static final int FORMAT_LOCALE = 1;
    public static final int FORMAT_ISO_8601 = 2;

    static {
        CALENDAR = Calendar.getInstance();
        MSECS_SINCE_1970 = CALENDAR.getTimeInMillis();
        SECS_SINCE_1970 = MSECS_SINCE_1970 / 1000L;
        SECS_SINCE_GARTRIP = SECS_SINCE_1970 - 631065600L;
        CALENDAR.add(1, -20);
        MSECS_SINCE_1990 = CALENDAR.getTimeInMillis();
        TWENTY_YEARS_IN_SECS = (MSECS_SINCE_1970 - MSECS_SINCE_1990) / 1000L;
        ALL_DATE_FORMATS = new DateFormat[]{DEFAULT_DATE_FORMAT, new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy"), new SimpleDateFormat("HH:mm:ss dd MMM yyyy"), new SimpleDateFormat("dd MMM yyyy HH:mm:ss"), new SimpleDateFormat("yyyy MMM dd HH:mm:ss"), ISO_8601_FORMAT, ISO_8601_FORMAT_NOZ};
    }

    /*
     * Unable to fully structure code
     */
    public Timestamp(String var1_1) {
        block9: {
            super();
            this._valid = false;
            this._seconds = 0L;
            this._text = null;
            this._timeText = null;
            if (var1_1 != null && !var1_1.equals("")) {
                try {
                    var2_2 = Long.parseLong(var1_1.trim());
                    this._seconds = Timestamp.getSeconds(var2_2);
                    this._valid = true;
                    break block9;
                }
                catch (NumberFormatException v0) {
                    var2_3 = null;
                    var3_4 = 0;
                    ** while (var3_4 < Timestamp.ALL_DATE_FORMATS.length && !this._valid)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var2_3 = Timestamp.ALL_DATE_FORMATS[var3_4].parse(var1_1);
                        Timestamp.CALENDAR.setTime(var2_3);
                        this._seconds = Timestamp.CALENDAR.getTimeInMillis() / 1000L;
                        this._valid = true;
                    }
                    catch (ParseException v1) {}
                    ++var3_4;
                    continue;
                }
lbl25:
                // 1 sources

                if (!this._valid && var1_1.length() == 19 && (Timestamp.GENERAL_TIMESTAMP_MATCHER = Timestamp.GENERAL_TIMESTAMP_PATTERN.matcher(var1_1)).matches()) {
                    try {
                        this._seconds = Timestamp.getSeconds(Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(1)), Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(2)), Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(3)), Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(4)), Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(5)), Integer.parseInt(Timestamp.GENERAL_TIMESTAMP_MATCHER.group(6)));
                        this._valid = true;
                    }
                    catch (NumberFormatException v2) {}
                }
            }
        }
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6) {
        this._valid = false;
        this._seconds = 0L;
        this._text = null;
        this._timeText = null;
        this._seconds = Timestamp.getSeconds(n, n2, n3, n4, n5, n6);
        this._valid = true;
    }

    public Timestamp(long l) {
        this._valid = false;
        this._seconds = 0L;
        this._text = null;
        this._timeText = null;
        this._seconds = l / 1000L;
        this._valid = true;
    }

    private static long getSeconds(int n, int n2, int n3, int n4, int n5, int n6) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        return calendar.getTimeInMillis() / 1000L;
    }

    private static long getSeconds(long l) {
        long l2 = Math.abs(SECS_SINCE_1970 - l);
        long l3 = Math.abs(MSECS_SINCE_1970 - l);
        long l4 = Math.abs(MSECS_SINCE_1990 - l);
        long l5 = Math.abs(SECS_SINCE_GARTRIP - l);
        long l6 = l2;
        long l7 = l;
        if (l3 < l6) {
            l7 = l / 1000L;
            l6 = l3;
        }
        if (l4 < l6) {
            l7 = l / 1000L + TWENTY_YEARS_IN_SECS;
            l6 = l4;
        }
        if (l5 < l6) {
            l7 = l + 631065600L;
        }
        return l7;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isAfter(Timestamp timestamp) {
        return this._seconds > timestamp._seconds;
    }

    public long getSecondsSince(Timestamp timestamp) {
        return this._seconds - timestamp._seconds;
    }

    public void addOffset(long l) {
        this._seconds += l;
        this._text = null;
    }

    public Timestamp createPlusOffset(TimeDifference timeDifference) {
        return new Timestamp((this._seconds + timeDifference.getTotalSeconds()) * 1000L);
    }

    public Timestamp createMinusOffset(TimeDifference timeDifference) {
        return new Timestamp((this._seconds - timeDifference.getTotalSeconds()) * 1000L);
    }

    public String getText() {
        return this.getText(1);
    }

    public String getText(int n) {
        if (!this._valid) {
            return "";
        }
        if (n == 2) {
            return this.format(ISO_8601_FORMAT);
        }
        if (this._text == null) {
            this._text = this._valid ? this.format(DEFAULT_DATE_FORMAT) : "";
        }
        return this._text;
    }

    public String getTimeText() {
        if (this._timeText == null) {
            this._timeText = this._valid ? this.format(DEFAULT_TIME_FORMAT) : "";
        }
        return this._timeText;
    }

    private String format(DateFormat dateFormat) {
        CALENDAR.setTimeInMillis(this._seconds * 1000L);
        return dateFormat.format(CALENDAR.getTime());
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._seconds * 1000L);
        return calendar;
    }
}

