/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoAddAltitudeOffset
implements UndoOperation {
    private int _startIndex;
    private Altitude[] _altitudes;

    public UndoAddAltitudeOffset(TrackInfo trackInfo) {
        this._startIndex = trackInfo.getSelection().getStart();
        int n = trackInfo.getSelection().getEnd();
        int n2 = n - this._startIndex + 1;
        this._altitudes = new Altitude[n2];
        int n3 = 0;
        while (n3 < n2) {
            Altitude altitude = trackInfo.getTrack().getPoint(this._startIndex + n3).getAltitude();
            if (altitude != null && altitude.isValid()) {
                this._altitudes[n3] = altitude.clone();
            }
            ++n3;
        }
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.addaltitudeoffset")) + " (" + this._altitudes.length + ")";
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        int n = this._altitudes.length;
        int n2 = 0;
        while (n2 < n) {
            trackInfo.getTrack().getPoint(n2 + this._startIndex).getAltitude().reset(this._altitudes[n2]);
            ++n2;
        }
        this._altitudes = null;
        UpdateMessageBroker.informSubscribers();
    }
}

