/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.data.SourceInfo;
import tim.prune.load.xml.GpxHandler;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class GzipFileLoader {
    private App _app = null;
    XmlFileLoader _xmlLoader = null;

    public GzipFileLoader(App app, XmlFileLoader xmlFileLoader) {
        this._app = app;
        this._xmlLoader = xmlFileLoader;
    }

    public void openFile(File file) {
        block13: {
            GZIPInputStream gZIPInputStream = null;
            try {
                try {
                    gZIPInputStream = new GZIPInputStream(new FileInputStream(file));
                    this._xmlLoader.reset();
                    SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                    sAXParser.parse((InputStream)gZIPInputStream, (DefaultHandler)this._xmlLoader);
                    XmlHandler xmlHandler = this._xmlLoader.getHandler();
                    if (xmlHandler == null) {
                        this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
                    } else {
                        SourceInfo sourceInfo = new SourceInfo(file, xmlHandler instanceof GpxHandler ? SourceInfo.FILE_TYPE.GPX : SourceInfo.FILE_TYPE.KML);
                        this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), Altitude.Format.METRES, sourceInfo);
                    }
                }
                catch (Exception exception) {
                    this._app.showErrorMessageNoLookup("error.load.dialogtitle", String.valueOf(I18nManager.getText("error.load.othererror")) + " " + exception.getClass().getName());
                    try {
                        gZIPInputStream.close();
                    }
                    catch (Exception exception2) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    gZIPInputStream.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                gZIPInputStream.close();
            }
            catch (Exception exception) {}
        }
    }
}

