/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.LatLonRectangle;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Photo;
import tim.prune.data.Timestamp;
import tim.prune.drew.jpeg.ExifReader;
import tim.prune.drew.jpeg.JpegData;
import tim.prune.drew.jpeg.JpegException;
import tim.prune.drew.jpeg.Rational;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.PhotoSorter;

public class JpegLoader
implements Runnable {
    private App _app = null;
    private JFrame _parentFrame = null;
    private JFileChooser _fileChooser = null;
    private GenericFileFilter _fileFilter = null;
    private JCheckBox _subdirCheckbox = null;
    private JCheckBox _noExifCheckbox = null;
    private JCheckBox _outsideAreaCheckbox = null;
    private JDialog _progressDialog = null;
    private JProgressBar _progressBar = null;
    private int[] _fileCounts = null;
    private boolean _cancelled = false;
    private LatLonRectangle _trackRectangle = null;
    private TreeSet<Photo> _photos = null;

    public JpegLoader(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
        String[] stringArray = new String[]{"jpg", "jpe", "jpeg"};
        this._fileFilter = new GenericFileFilter("filetype.jpeg", stringArray);
    }

    public void openDialog(LatLonRectangle latLonRectangle) {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setMultiSelectionEnabled(true);
            this._fileChooser.setFileSelectionMode(2);
            this._fileChooser.setFileFilter(this._fileFilter);
            this._fileChooser.setDialogTitle(I18nManager.getText("menu.file.addphotos"));
            this._subdirCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.subdirectories"));
            this._subdirCheckbox.setSelected(true);
            this._noExifCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.loadjpegswithoutcoords"));
            this._noExifCheckbox.setSelected(true);
            this._outsideAreaCheckbox = new JCheckBox(I18nManager.getText("dialog.jpegload.loadjpegsoutsidearea"));
            this._outsideAreaCheckbox.setSelected(true);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.add(this._subdirCheckbox);
            jPanel.add(this._noExifCheckbox);
            jPanel.add(this._outsideAreaCheckbox);
            this._fileChooser.setAccessory(jPanel);
            String string = Config.getConfigString("prune.photodirectory");
            if (string == null) {
                string = Config.getConfigString("prune.trackdirectory");
            }
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        this._trackRectangle = latLonRectangle;
        this._outsideAreaCheckbox.setEnabled(this._trackRectangle != null && !this._trackRectangle.isEmpty());
        if (this._fileChooser.showOpenDialog(this._parentFrame) == 0) {
            if (this._progressDialog == null) {
                this.createProgressDialog();
            }
            this._progressBar.setValue(0);
            this._progressBar.setString("");
            this._progressDialog.setVisible(true);
            new Thread(this).start();
        }
    }

    private void createProgressDialog() {
        this._progressDialog = new JDialog((Frame)this._parentFrame, I18nManager.getText("dialog.jpegload.progress.title"));
        this._progressDialog.setLocationRelativeTo(this._parentFrame);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        this._progressBar.setString("");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel.add(new JLabel(I18nManager.getText("dialog.jpegload.progress")));
        jPanel.add(this._progressBar);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JpegLoader.this._cancelled = true;
            }
        });
        jPanel.add(jButton);
        this._progressDialog.getContentPane().add(jPanel);
        this._progressDialog.pack();
    }

    public void run() {
        this._fileCounts = new int[4];
        this._photos = new TreeSet<Photo>(new PhotoSorter());
        File[] fileArray = this._fileChooser.getSelectedFiles();
        int n = this.countFileList(fileArray, true, this._subdirCheckbox.isSelected());
        this._progressBar.setMaximum(n);
        this._progressBar.setValue(0);
        this._cancelled = false;
        this.processFileList(fileArray, true, this._subdirCheckbox.isSelected());
        this._progressDialog.setVisible(false);
        this._progressDialog.dispose();
        if (this._cancelled) {
            return;
        }
        if (this._fileCounts[0] == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nofilesfound");
        } else if (this._fileCounts[1] == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nojpegsfound");
        } else if (!this._noExifCheckbox.isSelected() && this._fileCounts[2] == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.noexiffound");
        } else if (!this._noExifCheckbox.isSelected() && this._fileCounts[3] == 0) {
            this._app.showErrorMessage("error.jpegload.dialogtitle", "error.jpegload.nogpsfound");
        } else {
            this._app.informPhotosLoaded(this._photos);
        }
    }

    private void processFileList(File[] fileArray, boolean bl, boolean bl2) {
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length && !this._cancelled) {
                File file = fileArray[n];
                if (file.exists() && file.canRead()) {
                    if (file.isFile()) {
                        this.processFile(file);
                    } else if (file.isDirectory() && (bl || bl2)) {
                        File[] fileArray2 = file.listFiles();
                        this.processFileList(fileArray2, false, bl2);
                    }
                }
                ++n;
            }
        }
    }

    private void processFile(File file) {
        this._fileCounts[0] = this._fileCounts[0] + 1;
        this._progressBar.setValue(this._fileCounts[0]);
        this._progressBar.setString(this._fileCounts[0] + " / " + this._progressBar.getMaximum());
        this._progressBar.repaint();
        if (!this._fileFilter.acceptFilename(file.getName())) {
            return;
        }
        Photo photo = new Photo(file);
        try {
            JpegData jpegData = new ExifReader(file).extract();
            this._fileCounts[1] = this._fileCounts[1] + 1;
            if (jpegData.getExifDataPresent()) {
                this._fileCounts[2] = this._fileCounts[2] + 1;
            }
            if (jpegData.isValid()) {
                if (jpegData.getGpsDatestamp() != null && jpegData.getGpsTimestamp() != null) {
                    photo.setTimestamp(JpegLoader.createTimestamp(jpegData.getGpsDatestamp(), jpegData.getGpsTimestamp()));
                }
                DataPoint dataPoint = JpegLoader.createDataPoint(jpegData);
                dataPoint.setPhoto(photo);
                dataPoint.setSegmentStart(true);
                photo.setDataPoint(dataPoint);
                photo.setOriginalStatus(Photo.Status.TAGGED);
                this._fileCounts[3] = this._fileCounts[3] + 1;
            }
            if (photo.getTimestamp() == null && jpegData.getOriginalTimestamp() != null) {
                photo.setTimestamp(JpegLoader.createTimestamp(jpegData.getOriginalTimestamp()));
            }
            photo.setExifThumbnail(jpegData.getThumbnailImage());
            photo.setRotation(jpegData.getRequiredRotation());
        }
        catch (JpegException jpegException) {}
        if (photo.getTimestamp() == null) {
            photo.setTimestamp(new Timestamp(file.lastModified()));
        }
        if ((photo.getDataPoint() != null || this._noExifCheckbox.isSelected()) && (photo.getDataPoint() == null || !this._outsideAreaCheckbox.isEnabled() || this._outsideAreaCheckbox.isSelected() || this._trackRectangle.containsPoint(photo.getDataPoint()))) {
            this._photos.add(photo);
        }
    }

    private int countFileList(File[] fileArray, boolean bl, boolean bl2) {
        int n = 0;
        if (fileArray != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                File file = fileArray[n2];
                if (file.exists() && file.canRead()) {
                    if (n2 == 0 && bl) {
                        File file2 = file.isDirectory() ? file : file.getParentFile();
                        Config.setConfigString("prune.photodirectory", file2.getAbsolutePath());
                    }
                    if (file.isFile()) {
                        ++n;
                    } else if (file.isDirectory() && (bl || bl2)) {
                        n += this.countFileList(file.listFiles(), false, bl2);
                    }
                }
                ++n2;
            }
        }
        return n;
    }

    private static DataPoint createDataPoint(JpegData jpegData) {
        double d = JpegLoader.getCoordinateDoubleValue(jpegData.getLatitude(), jpegData.getLatitudeRef() == 'N' || jpegData.getLatitudeRef() == 'n');
        Latitude latitude = new Latitude(d, 10);
        double d2 = JpegLoader.getCoordinateDoubleValue(jpegData.getLongitude(), jpegData.getLongitudeRef() == 'E' || jpegData.getLongitudeRef() == 'e');
        Longitude longitude = new Longitude(d2, 10);
        Altitude altitude = null;
        if (jpegData.getAltitude() != null) {
            altitude = new Altitude(jpegData.getAltitude().intValue(), Altitude.Format.METRES);
        }
        return new DataPoint(latitude, longitude, altitude);
    }

    private static double getCoordinateDoubleValue(Rational[] rationalArray, boolean bl) {
        if (rationalArray == null || rationalArray.length != 3) {
            return 0.0;
        }
        double d = rationalArray[0].doubleValue() + rationalArray[1].doubleValue() / 60.0 + rationalArray[2].doubleValue() / 60.0 / 60.0;
        d = Math.abs(d);
        if (!bl) {
            d = -d;
        }
        return d;
    }

    private static Timestamp createTimestamp(Rational[] rationalArray, Rational[] rationalArray2) {
        return new Timestamp(rationalArray[0].intValue(), rationalArray[1].intValue(), rationalArray[2].intValue(), rationalArray2[0].intValue(), rationalArray2[1].intValue(), rationalArray2[2].intValue());
    }

    private static Timestamp createTimestamp(String string) {
        Timestamp timestamp = null;
        try {
            timestamp = new Timestamp(Integer.parseInt(string.substring(0, 4)), Integer.parseInt(string.substring(5, 7)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(11, 13)), Integer.parseInt(string.substring(14, 16)), Integer.parseInt(string.substring(17)));
        }
        catch (NumberFormatException numberFormatException) {}
        return timestamp;
    }
}

