/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.config.Config;

public class ScaleBar
extends JPanel {
    private int _zoomLevel = -1;
    private int _yTile = -1;
    private static final int LEFT_OFFSET = 20;
    private static final int Y_OFFSET = 10;
    private static final int TICK_HEIGHT = 5;
    private static final int MARGIN_WIDTH = 8;
    private static final int[] _metricScales = new int[]{10000, 5000, 2000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 2, 1, -2, -5, -10, -20, -50, -100, -200};
    private static final int[] _metricPixels = new int[]{64, 64, 51, 102, 102, 102, 81, 81, 81, 65, 65, 65, 52, 105, 105, 105, 83, 83, 83, 67, 67, 67};
    private static final int[] _mileScales = new int[]{10000, 10000, 5000, 2000, 2000, 1000, 500, 200, 100, 50, 20, 10, 5, 2, 1, -2, -2, -5, -10, -20, -50, -100};
    private static final int[] _milePixels = new int[]{79, 79, 79, 64, 127, 127, 127, 102, 102, 102, 81, 81, 81, 65, 65, 65, 130, 104, 104, 104, 104, 83, 83};

    public ScaleBar() {
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(100, 20));
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._zoomLevel > -1) {
            try {
                boolean bl = Config.getConfigBoolean("prune.metricunits");
                int n = 20 + (bl ? _metricPixels[this._zoomLevel] : _milePixels[this._zoomLevel]);
                int n2 = bl ? _metricScales[this._zoomLevel] : _mileScales[this._zoomLevel];
                double d = Math.pow(2.0, this._zoomLevel);
                double d2 = Math.PI * (1.0 - 2.0 * (double)this._yTile / d);
                double d3 = Math.atan(Math.sinh(d2));
                double d4 = Math.cos(d3);
                for (n = (int)((double)n / d4); n > 300; n /= 2) {
                    if ((n2 /= 2) >= 1) continue;
                    return;
                }
                Color color = Config.getColourScheme().getColour(3);
                Color color2 = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
                graphics.setColor(color2);
                graphics.drawLine(20, 9, n + 2, 9);
                graphics.drawLine(20, 12, n + 2, 12);
                graphics.drawLine(19, 12, 19, 5);
                graphics.drawLine(22, 12, 22, 5);
                graphics.drawLine(n - 1, 12, n - 1, 5);
                graphics.drawLine(n + 2, 12, n + 2, 5);
                graphics.setColor(color);
                graphics.drawLine(20, 10, n, 10);
                graphics.drawLine(20, 11, n, 11);
                graphics.drawLine(20, 10, 20, 5);
                graphics.drawLine(21, 10, 21, 5);
                graphics.drawLine(n, 11, n, 5);
                graphics.drawLine(n + 1, 11, n + 1, 5);
                String string = String.valueOf(n2 > 0 ? "" + n2 : "1/" + -n2) + " " + I18nManager.getText(bl ? "units.kilometres.short" : "units.miles.short");
                graphics.setColor(color2);
                graphics.drawString(string, n + 8 - 1, 10);
                graphics.drawString(string, n + 8 + 1, 10);
                graphics.drawString(string, n + 8, 9);
                graphics.drawString(string, n + 8, 11);
                graphics.setColor(color);
                graphics.drawString(string, n + 8, 10);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    public void updateScale(int n, int n2) {
        this._zoomLevel = n;
        this._yTile = n2;
    }
}

