/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.I18nManager;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.PhotoListModel;
import tim.prune.gui.WaypointListModel;

public class SelectorDisplay
extends GenericDisplay {
    private JLabel _trackpointsLabel = null;
    private JLabel _filenameLabel = null;
    private JScrollBar _scroller = null;
    private boolean _ignoreScrollEvents = false;
    private JList _photoList = null;
    private PhotoListModel _photoListModel = null;
    private JList _waypointList = null;
    private WaypointListModel _waypointListModel = null;
    private static final int SCROLLBAR_INTERVAL = 50;
    private static final int NUM_LIST_ENTRIES = 7;

    public SelectorDisplay(TrackInfo trackInfo) {
        super(trackInfo);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText("details.trackdetails"));
        Font font = jLabel.getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        jLabel.setFont(font);
        jPanel2.add(jLabel);
        this._trackpointsLabel = new JLabel(I18nManager.getText("details.notrack"));
        jPanel2.add(this._trackpointsLabel);
        this._filenameLabel = new JLabel("");
        jPanel2.add(this._filenameLabel);
        this._scroller = new JScrollBar(0, 0, 50, 0, 100);
        this._scroller.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SelectorDisplay.this.selectPoint(adjustmentEvent.getValue());
            }
        });
        this._scroller.setEnabled(false);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 1));
        jPanel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this._waypointListModel = new WaypointListModel(this._trackInfo.getTrack());
        this._waypointList = new JList(this._waypointListModel);
        this._waypointList.setVisibleRowCount(7);
        this._waypointList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectorDisplay.this.selectWaypoint(SelectorDisplay.this._waypointList.getSelectedIndex());
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)new JLabel(I18nManager.getText("details.waypointsphotos.waypoints")), "North");
        jPanel4.add((Component)new JScrollPane(this._waypointList), "Center");
        jPanel3.add(jPanel4);
        this._photoListModel = new PhotoListModel(this._trackInfo.getPhotoList());
        this._photoList = new JList(this._photoListModel);
        this._photoList.setVisibleRowCount(7);
        this._photoList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    SelectorDisplay.this.selectPhoto(SelectorDisplay.this._photoList.getSelectedIndex());
                }
            }
        });
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)new JLabel(I18nManager.getText("details.waypointsphotos.photos")), "North");
        jPanel5.add((Component)new JScrollPane(this._photoList), "Center");
        jPanel3.add(jPanel5);
        jPanel3.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(5));
        jPanel.add(this._scroller);
        jPanel.add(Box.createVerticalStrut(5));
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel3, "Center");
        this.setPreferredSize(new Dimension(100, 100));
    }

    private void selectPoint(int n) {
        if (this._track != null && !this._ignoreScrollEvents) {
            this._trackInfo.selectPoint(n);
        }
    }

    private void selectPhoto(int n) {
        this._trackInfo.selectPhoto(n);
    }

    private void selectWaypoint(int n) {
        if (n >= 0) {
            this._trackInfo.selectPoint(this._waypointListModel.getWaypoint(n));
        }
    }

    public void dataUpdated(byte by) {
        int n;
        if (this._track == null || this._track.getNumPoints() <= 0) {
            this._trackpointsLabel.setText(I18nManager.getText("details.notrack"));
            this._filenameLabel.setText("");
        } else {
            this._trackpointsLabel.setText(String.valueOf(I18nManager.getText("details.track.points")) + ": " + this._track.getNumPoints());
            n = this._trackInfo.getFileInfo().getNumFiles();
            if (n == 1) {
                this._filenameLabel.setText(String.valueOf(I18nManager.getText("details.track.file")) + ": " + this._trackInfo.getFileInfo().getFilename());
            } else if (n > 1) {
                this._filenameLabel.setText(String.valueOf(I18nManager.getText("details.track.numfiles")) + ": " + n);
            } else {
                this._filenameLabel.setText("");
            }
        }
        n = this._trackInfo.getSelection().getCurrentPointIndex();
        this._ignoreScrollEvents = true;
        if (this._track == null || this._track.getNumPoints() < 2) {
            this._scroller.setEnabled(false);
        } else {
            this._scroller.setMaximum(this._track.getNumPoints() - 1 + 50);
            if (n >= 0) {
                this._scroller.setValue(n);
            }
            this._scroller.setEnabled(true);
        }
        this._ignoreScrollEvents = false;
        if ((by | 0xB) > 0) {
            this._waypointListModel.fireChanged();
        }
        if ((by | 0x13) > 0) {
            this._photoListModel.fireChanged();
        }
        if (!(this._waypointList.getSelectedIndex() < 0 || this._trackInfo.getCurrentPoint() != null && this._waypointList.getSelectedIndex() < this._waypointListModel.getSize() && this._waypointListModel.getWaypoint(this._waypointList.getSelectedIndex()).equals(this._trackInfo.getCurrentPoint()))) {
            this._waypointList.clearSelection();
        }
        if (this._photoListModel.getSize() > 0) {
            int n2 = this._trackInfo.getSelection().getCurrentPhotoIndex();
            int n3 = this._photoList.getSelectedIndex();
            if (n3 != n2) {
                if (n2 < 0) {
                    this._photoList.clearSelection();
                } else {
                    this._photoList.setSelectedIndex(n2);
                }
            }
        }
    }
}

