/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericChart;

public class ProfileChart
extends GenericChart {
    private double _xScaleFactor = 0.0;
    private static final int[] ALTITUDE_SCALES = new int[]{10000, 5000, 2000, 1000, 500, 200, 100, 50};

    public ProfileChart(TrackInfo trackInfo) {
        super(trackInfo);
        this.MINIMUM_SIZE = new Dimension(200, 100);
        this.addMouseListener(this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._track != null && this._track.getNumPoints() > 0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Color color = Config.getColourScheme().getColour(1);
            Color color2 = Config.getColourScheme().getColour(2);
            Color color3 = Config.getColourScheme().getColour(4);
            Color color4 = Config.getColourScheme().getColour(5);
            Color color5 = Config.getColourScheme().getColour(7);
            if (!this._track.hasAltitudeData()) {
                graphics.setColor(color5);
                graphics.drawString(I18nManager.getText("display.noaltitudes"), 50, n2 / 2);
                return;
            }
            AltitudeRange altitudeRange = this._track.getAltitudeRange();
            int n3 = altitudeRange.getMinimum();
            int n4 = altitudeRange.getMaximum();
            int n5 = this._track.getNumPoints();
            this._xScaleFactor = 1.0 * (double)(n - 16 - 1) / (double)n5;
            double d = 1.0 * (double)(n2 - 16) / (double)(n4 - n3);
            int n6 = (int)(this._xScaleFactor + 1.0);
            int n7 = this._trackInfo.getSelection().getCurrentPointIndex();
            int n8 = -1;
            int n9 = -1;
            if (this._trackInfo.getSelection().hasRangeSelected()) {
                n8 = this._trackInfo.getSelection().getStart();
                n9 = this._trackInfo.getSelection().getEnd();
            }
            int n10 = this.getLineScale(n3, n4);
            int n11 = n3 / n10 * n10;
            int n12 = 0;
            int n13 = 0;
            if (n10 > 1) {
                graphics.setColor(color5);
                while (n11 < n4) {
                    if (n11 > n3) {
                        n13 = n2 - 8 - (int)(d * (double)(n11 - n3));
                        graphics.drawLine(9, n13, n - 8 - 1, n13);
                    }
                    n11 += n10;
                }
            }
            try {
                Altitude altitude;
                Altitude.Format format = altitudeRange.getFormat();
                graphics.setColor(color);
                int n14 = 0;
                while (n14 < n5) {
                    n12 = (int)(this._xScaleFactor * (double)n14) + 1;
                    if (n14 == n8) {
                        graphics.setColor(color2);
                    } else if (n14 == n9 + 1) {
                        graphics.setColor(color);
                    }
                    if (this._track.getPoint(n14).getAltitude().isValid()) {
                        n11 = this._track.getPoint(n14).getAltitude().getValue(format);
                        n13 = (int)(d * (double)(n11 - n3));
                        graphics.fillRect(8 + n12, n2 - 8 - n13, n6, n13);
                    }
                    ++n14;
                }
                if (n7 > -1 && (altitude = this._track.getPoint(n7).getAltitude()).isValid()) {
                    n12 = (int)(this._xScaleFactor * (double)n7) + 1;
                    graphics.setColor(color4);
                    graphics.fillRect(8 + n12, 9, n6, n2 - 16 - 2);
                    graphics.setColor(color3);
                    n11 = altitude.getValue(format);
                    n13 = (int)(d * (double)(n11 - n3));
                    graphics.fillRect(8 + n12, n2 - 8 - n13, n6, n13);
                }
            }
            catch (NullPointerException nullPointerException) {}
            if (n10 > 1) {
                int n15 = graphics.getFontMetrics().getHeight();
                n11 = n3 / n10 * n10;
                n13 = 0;
                graphics.setColor(color3);
                while (n11 < n4) {
                    if (n11 > n3) {
                        n13 = n2 - 8 - (int)(d * (double)(n11 - n3));
                        if (n13 < 8 + n15) {
                            n13 = 8 + n15;
                        }
                        graphics.drawString("" + n11, 13, n13);
                    }
                    n11 += n10;
                }
            }
        }
    }

    private int getLineScale(int n, int n2) {
        if (n2 - n < 50 || n2 < 0) {
            return -1;
        }
        int n3 = ALTITUDE_SCALES.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5 = ALTITUDE_SCALES[n4];
            int n6 = n2 / n5 - n / n5;
            if (n6 > 10) {
                return -1;
            }
            if (n6 > 1) {
                return n5;
            }
            ++n4;
        }
        return ALTITUDE_SCALES[n3 - 1];
    }

    public void dataUpdated(Track track) {
        this._track = track;
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track != null && !mouseEvent.isMetaDown()) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n > 8 && n2 > 8 && n < this.getWidth() - 8 && n2 < this.getHeight() - 8) {
                int n3 = (int)((double)(mouseEvent.getX() - 8) / this._xScaleFactor);
                if (mouseEvent.isShiftDown()) {
                    this._trackInfo.extendSelection(n3);
                } else {
                    this._trackInfo.selectPoint(n3);
                }
            }
        }
    }
}

