/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.Photo;
import tim.prune.gui.ImageUtils;

public class PhotoThumbnail
extends JPanel
implements Runnable {
    private Photo _photo = null;
    private BufferedImage _thumbnail = null;
    private boolean _loadingImage = false;
    private static final String LOADING_STRING = String.valueOf(I18nManager.getText("details.photo.loading")) + " ...";

    public PhotoThumbnail() {
        this.setOpaque(true);
    }

    public void setPhoto(Photo photo) {
        if (this._photo != photo) {
            this._photo = photo;
            this._thumbnail = null;
        }
        this.repaint();
    }

    public void refresh() {
        this._thumbnail = null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._photo != null) {
            if (this._thumbnail == null && !this._loadingImage) {
                this._loadingImage = true;
                new Thread(this).start();
            }
            if (this._loadingImage) {
                graphics.setColor(Color.BLACK);
                graphics.drawString(LOADING_STRING, 10, 30);
            } else {
                int n = this.getParent().getWidth() - 10;
                BufferedImage bufferedImage = ImageUtils.rotateImage(this._thumbnail, n, n, this._photo.getRotationDegrees());
                int n2 = ((Image)bufferedImage).getWidth(null);
                int n3 = ((Image)bufferedImage).getHeight(null);
                int n4 = (this.getWidth() - n2) / 2;
                int n5 = (this.getHeight() - n3) / 2;
                graphics.drawImage(bufferedImage, n4, n5, n2, n3, null);
                if (this.getHeight() < this.getWidth()) {
                    this.setPreferredSize(new Dimension(n, n));
                    this.invalidate();
                }
            }
        }
    }

    public void run() {
        if (this._photo.getExifThumbnail() != null) {
            Image image = new ImageIcon(this._photo.getExifThumbnail()).getImage();
            this._thumbnail = ImageUtils.createScaledImage(image, image.getWidth(null), image.getHeight(null));
            image = null;
        } else {
            int n = this._photo.getWidth();
            int n2 = this._photo.getHeight();
            if (n > -1 && n2 > -1) {
                Dimension dimension = ImageUtils.getThumbnailSize(n, n2, 400, 400);
                Image image = new ImageIcon(this._photo.getFile().getAbsolutePath()).getImage();
                this._thumbnail = ImageUtils.createScaledImage(image, dimension.width, dimension.height);
                image = null;
            }
        }
        this._loadingImage = false;
        this.repaint();
    }
}

