/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Distance;
import tim.prune.function.gpsies.GpsiesTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackListModel
extends AbstractTableModel {
    private ArrayList<GpsiesTrack> _trackList = null;
    private static final String _nameColLabel = I18nManager.getText("dialog.gpsies.column.name");
    private static final String _lengthColLabel = I18nManager.getText("dialog.gpsies.column.length");
    private NumberFormat _distanceFormatter = NumberFormat.getInstance();

    public TrackListModel() {
        this._distanceFormatter.setMaximumFractionDigits(1);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        if (this._trackList == null) {
            return 0;
        }
        return this._trackList.size();
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return _nameColLabel;
        }
        return _lengthColLabel;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        GpsiesTrack gpsiesTrack = this._trackList.get(n);
        if (n2 == 0) {
            return gpsiesTrack.getTrackName();
        }
        double d = gpsiesTrack.getLength();
        if (Config.getConfigBoolean("prune.metricunits")) {
            return String.valueOf(this._distanceFormatter.format(d / 1000.0)) + " " + I18nManager.getText("units.kilometres.short");
        }
        return String.valueOf(this._distanceFormatter.format(Distance.convertMetresToMiles(d))) + " " + I18nManager.getText("units.miles.short");
    }

    public void addTracks(ArrayList<GpsiesTrack> arrayList) {
        if (this._trackList == null) {
            this._trackList = new ArrayList();
        }
        if (arrayList != null && arrayList.size() > 0) {
            this._trackList.addAll(arrayList);
        }
        this.fireTableDataChanged();
    }

    public GpsiesTrack getTrack(int n) {
        return this._trackList.get(n);
    }

    public void clear() {
        this._trackList = null;
    }
}

