/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;

public class SetMapBgFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private JRadioButton[] _serverRadios = null;
    private JTextField _serverUrl = null;
    private static final int OTHER_SERVER_NUM = 3;

    public SetMapBgFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setmapbg";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this.initValues();
            this._dialog.pack();
        }
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this._serverRadios = new JRadioButton[4];
        ButtonGroup buttonGroup = new ButtonGroup();
        String[] stringArray = new String[]{"dialog.setmapbg.mapnik", "dialog.setmapbg.osma", "dialog.setmapbg.cyclemap", "dialog.setmapbg.other"};
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.enableOK();
            }
        };
        int n = 0;
        while (n < 4) {
            this._serverRadios[n] = new JRadioButton(I18nManager.getText(stringArray[n]));
            this._serverRadios[n].addActionListener(actionListener);
            buttonGroup.add(this._serverRadios[n]);
            jPanel2.add(this._serverRadios[n]);
            ++n;
        }
        jPanel2.add(new JLabel(I18nManager.getText("dialog.setmapbg.server")));
        this._serverUrl = new JTextField("", 12);
        this._serverUrl.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                SetMapBgFunction.this.enableOK();
            }
        });
        jPanel2.add(this._serverUrl);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener2);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetMapBgFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void initValues() {
        try {
            this._serverRadios[Config.getConfigInt("prune.mapserverindex")].setSelected(true);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        String string = Config.getConfigString("prune.mapserverurl");
        if (string != null) {
            this._serverUrl.setText(string);
        }
        if (this.getSelectedServer() < 0) {
            this._serverRadios[0].setSelected(true);
        }
    }

    private int getSelectedServer() {
        int n = 0;
        while (n < 4) {
            if (this._serverRadios[n].isSelected()) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void enableOK() {
        int n = this.getSelectedServer();
        this._okButton.setEnabled(this.inputOK());
        this._serverUrl.setEnabled(n == 3);
    }

    private boolean inputOK() {
        int n = this.getSelectedServer();
        return n >= 0 && (n != 3 || this._serverUrl.getText().length() > 4);
    }

    private void finish() {
        int n = this.getSelectedServer();
        if (!this.inputOK()) {
            n = 0;
        }
        Config.setConfigInt("prune.mapserverindex", n);
        Config.setConfigString("prune.mapserverurl", this._serverUrl.getText());
        UpdateMessageBroker.informSubscribers((byte)64);
        this._dialog.dispose();
    }
}

