/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.drew.jpeg;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import tim.prune.drew.jpeg.JpegException;
import tim.prune.drew.jpeg.JpegSegmentData;

public class JpegSegmentReader {
    private static final byte SEGMENT_SOS = -38;
    private static final byte MARKER_EOI = -39;
    public static final byte SEGMENT_APP0 = -32;
    public static final byte SEGMENT_APP1 = -31;
    public static final byte SEGMENT_APP2 = -30;
    public static final byte SEGMENT_APP3 = -29;
    public static final byte SEGMENT_APP4 = -28;
    public static final byte SEGMENT_APP5 = -27;
    public static final byte SEGMENT_APP6 = -26;
    public static final byte SEGMENT_APP7 = -25;
    public static final byte SEGMENT_APP8 = -24;
    public static final byte SEGMENT_APP9 = -23;
    public static final byte SEGMENT_APPA = -22;
    public static final byte SEGMENT_APPB = -21;
    public static final byte SEGMENT_APPC = -20;
    public static final byte SEGMENT_APPD = -19;
    public static final byte SEGMENT_APPE = -18;
    public static final byte SEGMENT_APPF = -17;
    public static final byte SEGMENT_SOI = -40;
    public static final byte SEGMENT_DQT = -37;
    public static final byte SEGMENT_DHT = -60;
    public static final byte SEGMENT_SOF0 = -64;
    public static final byte SEGMENT_COM = -2;
    private static final int MAGIC_JPEG_BYTE_1 = 255;
    private static final int MAGIC_JPEG_BYTE_2 = 216;

    public static JpegSegmentData readSegments(File file) throws JpegException {
        JpegSegmentData jpegSegmentData = new JpegSegmentData();
        BufferedInputStream bufferedInputStream = null;
        try {
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                int n = 0;
                int n2 = bufferedInputStream.read() & 0xFF;
                int n3 = bufferedInputStream.read() & 0xFF;
                JpegSegmentReader.checkMagicNumbers(n2, n3);
                n += 2;
                while (true) {
                    byte by;
                    if (((by = (byte)(bufferedInputStream.read() & 0xFF)) & 0xFF) != 255) {
                        throw new JpegException("expected jpeg segment start identifier 0xFF at offset " + n + ", not 0x" + Integer.toHexString(by & 0xFF));
                    }
                    ++n;
                    byte by2 = (byte)(bufferedInputStream.read() & 0xFF);
                    ++n;
                    byte[] byArray = new byte[2];
                    bufferedInputStream.read(byArray, 0, 2);
                    n += 2;
                    int n4 = byArray[0] << 8 & 0xFF00 | byArray[1] & 0xFF;
                    if ((n4 -= 2) > bufferedInputStream.available()) {
                        throw new JpegException("segment size would extend beyond file stream length");
                    }
                    if (n4 < 0) {
                        throw new JpegException("segment size would be less than zero");
                    }
                    byte[] byArray2 = new byte[n4];
                    bufferedInputStream.read(byArray2, 0, n4);
                    n += n4;
                    if ((by2 & 0xFF) == 218) {
                        break;
                    }
                    if ((by2 & 0xFF) == 217) {
                        break;
                    }
                    jpegSegmentData.addSegment(by2, byArray2);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new JpegException("Jpeg file not found");
            }
            catch (IOException iOException) {
                throw new JpegException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new JpegException("IOException processing Jpeg file: " + iOException.getMessage(), iOException);
            }
        }
        return jpegSegmentData;
    }

    private static void checkMagicNumbers(int n, int n2) throws JpegException {
        if (n != 255 || n2 != 216) {
            throw new JpegException("not a jpeg file");
        }
    }
}

