/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import tim.prune.data.TimeDifference;

public class Timestamp {
    private boolean _valid;
    private long _seconds;
    private String _text;
    private String _timeText;
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateTimeInstance();
    private static final DateFormat DEFAULT_TIME_FORMAT = DateFormat.getTimeInstance();
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final DateFormat ISO_8601_FORMAT_NOZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private static DateFormat[] ALL_DATE_FORMATS = null;
    private static Calendar CALENDAR = null;
    private static long SECS_SINCE_1970 = 0L;
    private static long SECS_SINCE_GARTRIP = 0L;
    private static long MSECS_SINCE_1970 = 0L;
    private static long MSECS_SINCE_1990 = 0L;
    private static long TWENTY_YEARS_IN_SECS = 0L;
    private static final long GARTRIP_OFFSET = 631065600L;
    public static final int FORMAT_ORIGINAL = 0;
    public static final int FORMAT_LOCALE = 1;
    public static final int FORMAT_ISO_8601 = 2;

    static {
        CALENDAR = Calendar.getInstance();
        MSECS_SINCE_1970 = CALENDAR.getTimeInMillis();
        SECS_SINCE_1970 = MSECS_SINCE_1970 / 1000L;
        SECS_SINCE_GARTRIP = SECS_SINCE_1970 - 631065600L;
        CALENDAR.add(1, -20);
        MSECS_SINCE_1990 = CALENDAR.getTimeInMillis();
        TWENTY_YEARS_IN_SECS = (MSECS_SINCE_1970 - MSECS_SINCE_1990) / 1000L;
        ALL_DATE_FORMATS = new DateFormat[]{DEFAULT_DATE_FORMAT, new SimpleDateFormat("EEE MMM dd HH:mm:ss yyyy"), new SimpleDateFormat("HH:mm:ss dd MMM yyyy"), new SimpleDateFormat("dd MMM yyyy HH:mm:ss"), new SimpleDateFormat("yyyy MMM dd HH:mm:ss"), ISO_8601_FORMAT, ISO_8601_FORMAT_NOZ};
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp(String string) {
        block9: {
            int n;
            Date date;
            block8: {
                this._valid = false;
                this._seconds = 0L;
                this._text = null;
                this._timeText = null;
                if (string == null) return;
                if (string.equals("")) return;
                try {
                    long l = Long.parseLong(string.trim());
                    long l2 = Math.abs(SECS_SINCE_1970 - l);
                    long l3 = Math.abs(MSECS_SINCE_1970 - l);
                    long l4 = Math.abs(MSECS_SINCE_1990 - l);
                    long l5 = Math.abs(SECS_SINCE_GARTRIP - l);
                    long l6 = l2;
                    this._seconds = l;
                    if (l3 < l6) {
                        this._seconds = l / 1000L;
                        l6 = l3;
                    }
                    if (l4 < l6) {
                        this._seconds = l / 1000L + TWENTY_YEARS_IN_SECS;
                        l6 = l4;
                    }
                    if (l5 < l6) {
                        this._seconds = l + 631065600L;
                    }
                    this._valid = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    date = null;
                    n = 0;
                    if (!true) break block8;
                    if (n >= ALL_DATE_FORMATS.length) return;
                    if (this._valid) break block9;
                }
            }
            do {
                try {
                    date = ALL_DATE_FORMATS[n].parse(string);
                    CALENDAR.setTime(date);
                    this._seconds = CALENDAR.getTimeInMillis() / 1000L;
                    this._valid = true;
                }
                catch (ParseException parseException) {}
                ++n;
                if (n >= ALL_DATE_FORMATS.length) return;
            } while (!this._valid);
        }
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6) {
        this._valid = false;
        this._seconds = 0L;
        this._text = null;
        this._timeText = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
        calendar.set(11, n4);
        calendar.set(12, n5);
        calendar.set(13, n6);
        calendar.set(14, 0);
        this._seconds = calendar.getTimeInMillis() / 1000L;
        this._valid = true;
    }

    public Timestamp(long l) {
        this._valid = false;
        this._seconds = 0L;
        this._text = null;
        this._timeText = null;
        this._seconds = l / 1000L;
        this._valid = true;
    }

    public boolean isValid() {
        return this._valid;
    }

    public boolean isAfter(Timestamp timestamp) {
        return this._seconds > timestamp._seconds;
    }

    public long getSecondsSince(Timestamp timestamp) {
        return this._seconds - timestamp._seconds;
    }

    public void addOffset(long l) {
        this._seconds += l;
        this._text = null;
    }

    public Timestamp createPlusOffset(TimeDifference timeDifference) {
        return new Timestamp((this._seconds + timeDifference.getTotalSeconds()) * 1000L);
    }

    public Timestamp createMinusOffset(TimeDifference timeDifference) {
        return new Timestamp((this._seconds - timeDifference.getTotalSeconds()) * 1000L);
    }

    public String getText() {
        return this.getText(1);
    }

    public String getText(int n) {
        if (n == 2) {
            return this.format(ISO_8601_FORMAT);
        }
        if (this._text == null) {
            this._text = this._valid ? this.format(DEFAULT_DATE_FORMAT) : "";
        }
        return this._text;
    }

    public String getTimeText() {
        if (this._timeText == null) {
            this._timeText = this._valid ? this.format(DEFAULT_TIME_FORMAT) : "";
        }
        return this._timeText;
    }

    private String format(DateFormat dateFormat) {
        CALENDAR.setTimeInMillis(this._seconds * 1000L);
        return dateFormat.format(CALENDAR.getTime());
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this._seconds * 1000L);
        return calendar;
    }
}

