/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.io.File;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public class SourceInfo {
    private File _sourceFile = null;
    private String _sourceName = null;
    private FILE_TYPE _fileType = null;
    private DataPoint[] _points = null;

    public SourceInfo(File file, FILE_TYPE fILE_TYPE) {
        this._sourceFile = file;
        this._sourceName = file.getName();
        this._fileType = fILE_TYPE;
    }

    public SourceInfo(String string, FILE_TYPE fILE_TYPE) {
        this._sourceFile = null;
        this._sourceName = string;
        this._fileType = fILE_TYPE;
    }

    public File getFile() {
        return this._sourceFile;
    }

    public String getName() {
        return this._sourceName;
    }

    public FILE_TYPE getFileType() {
        return this._fileType;
    }

    public int getNumPoints() {
        return this._points.length;
    }

    public void populatePointObjects(Track track, int n) {
        if (n > 0) {
            this._points = new DataPoint[n];
            int n2 = track.getNumPoints();
            System.arraycopy(track.cloneContents(), n2 - n, this._points, 0, n);
        }
    }

    public int getIndex(DataPoint dataPoint) {
        int n = -1;
        int n2 = 0;
        while (n2 < this._points.length && n < 0) {
            if (this._points[n2] == dataPoint) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FILE_TYPE {
        TEXT,
        GPX,
        KML,
        NMEA,
        GPSBABEL,
        GPSIES;

    }
}

