/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.awt.Dimension;
import java.io.File;
import javax.swing.ImageIcon;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public class Photo {
    private File _file = null;
    private Timestamp _timestamp = null;
    private DataPoint _dataPoint = null;
    private Dimension _size = null;
    private Status _originalStatus = Status.NOT_CONNECTED;
    private Status _currentStatus = Status.NOT_CONNECTED;
    private int _rotation = 0;
    private byte[] _exifThumbnail = null;

    public Photo(File file) {
        this._file = file;
    }

    public File getFile() {
        return this._file;
    }

    public void setDataPoint(DataPoint dataPoint) {
        this._dataPoint = dataPoint;
        if (dataPoint == null) {
            this.setCurrentStatus(Status.NOT_CONNECTED);
        } else {
            this.setCurrentStatus(Status.CONNECTED);
        }
    }

    public DataPoint getDataPoint() {
        return this._dataPoint;
    }

    public void setTimestamp(Timestamp timestamp) {
        this._timestamp = timestamp;
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    private void calculateSize() {
        ImageIcon imageIcon = new ImageIcon(this._file.getAbsolutePath());
        int n = imageIcon.getIconWidth();
        int n2 = imageIcon.getIconHeight();
        if (n > 0 && n2 > 0) {
            this._size = new Dimension(n, n2);
        }
    }

    public Dimension getSize() {
        if (this._size == null) {
            this.calculateSize();
        }
        return this._size;
    }

    public int getWidth() {
        if (this._size == null) {
            this.calculateSize();
            if (this._size == null) {
                return -1;
            }
        }
        return this._size.width;
    }

    public int getHeight() {
        if (this._size == null) {
            this.calculateSize();
            if (this._size == null) {
                return -1;
            }
        }
        return this._size.height;
    }

    public void setOriginalStatus(Status status) {
        this._originalStatus = status;
        this._currentStatus = status;
    }

    public Status getOriginalStatus() {
        return this._originalStatus;
    }

    public Status getCurrentStatus() {
        return this._currentStatus;
    }

    public void setCurrentStatus(Status status) {
        this._currentStatus = status;
    }

    public boolean isConnected() {
        return this._currentStatus != Status.NOT_CONNECTED;
    }

    public byte[] getExifThumbnail() {
        return this._exifThumbnail;
    }

    public void setExifThumbnail(byte[] byArray) {
        this._exifThumbnail = byArray;
    }

    public void resetCachedData() {
        this._size = null;
    }

    public boolean equals(Photo photo) {
        return photo != null && photo.getFile() != null && this.getFile() != null && photo.getFile().equals(this.getFile());
    }

    public void setRotation(int n) {
        if (n >= 0 && n <= 3) {
            this._rotation = n;
        }
    }

    public void rotate(boolean bl) {
        int n = bl ? 1 : 3;
        this._rotation = (this._rotation + n) % 4;
    }

    public int getRotationDegrees() {
        return this._rotation * 90;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_CONNECTED,
        TAGGED,
        CONNECTED;

    }
}

