/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.Coordinate;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Photo;
import tim.prune.data.Timestamp;

public class DataPoint {
    private String[] _fieldValues = null;
    private FieldList _fieldList = null;
    private Coordinate _latitude = null;
    private Coordinate _longitude = null;
    private Altitude _altitude;
    private Timestamp _timestamp = null;
    private Photo _photo = null;
    private String _waypointName = null;
    private boolean _startOfSegment = false;
    private boolean _markedForDeletion = false;
    private int _modifyCount = 0;

    public DataPoint(String[] stringArray, FieldList fieldList, Altitude.Format format) {
        this._fieldValues = stringArray;
        this._fieldList = fieldList;
        this.parseFields(null, format);
    }

    private void parseFields(Field field, Altitude.Format format) {
        if (field == null || field == Field.LATITUDE) {
            this._latitude = new Latitude(this.getFieldValue(Field.LATITUDE));
        }
        if (field == null || field == Field.LONGITUDE) {
            this._longitude = new Longitude(this.getFieldValue(Field.LONGITUDE));
        }
        if (field == null || field == Field.ALTITUDE) {
            this._altitude = new Altitude(this.getFieldValue(Field.ALTITUDE), format);
        }
        if (field == null || field == Field.TIMESTAMP) {
            this._timestamp = new Timestamp(this.getFieldValue(Field.TIMESTAMP));
        }
        if (field == null || field == Field.WAYPT_NAME) {
            this._waypointName = this.getFieldValue(Field.WAYPT_NAME);
        }
        if (field == null || field == Field.NEW_SEGMENT) {
            String string = this.getFieldValue(Field.NEW_SEGMENT);
            if (string != null) {
                string = string.trim();
            }
            this._startOfSegment = string != null && (string.equals("1") || string.toUpperCase().equals("Y"));
        }
    }

    public DataPoint(Coordinate coordinate, Coordinate coordinate2, Altitude altitude) {
        this._fieldValues = new String[3];
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE};
        this._fieldList = new FieldList(fieldArray);
        this._latitude = coordinate;
        this._fieldValues[0] = coordinate.output(19);
        this._longitude = coordinate2;
        this._fieldValues[1] = coordinate2.output(19);
        if (altitude == null) {
            this._altitude = Altitude.NONE;
        } else {
            this._altitude = altitude;
            this._fieldValues[2] = "" + altitude.getValue();
        }
        this._timestamp = new Timestamp(null);
    }

    public String getFieldValue(Field field) {
        return this.getFieldValue(this._fieldList.getFieldIndex(field));
    }

    public String getFieldValue(int n) {
        if (this._fieldValues == null || n < 0 || n >= this._fieldValues.length) {
            return null;
        }
        return this._fieldValues[n];
    }

    public void setFieldValue(Field field, String string, boolean bl) {
        int n = this._fieldList.getFieldIndex(field);
        if (n < 0) {
            if (string == null || string.equals("")) {
                return;
            }
            n = this._fieldList.extendList(field);
        }
        if (n >= this._fieldValues.length) {
            this.resizeValueArray(n);
        }
        this._fieldValues[n] = string;
        if (field != Field.NEW_SEGMENT) {
            this._modifyCount = !bl ? ++this._modifyCount : --this._modifyCount;
        }
        if (this._altitude != null && this._altitude.getFormat() != Altitude.Format.NO_FORMAT) {
            this.parseFields(field, this._altitude.getFormat());
        } else {
            this.parseFields(field, Config.getConfigBoolean("prune.metricunits") ? Altitude.Format.METRES : Altitude.Format.FEET);
        }
    }

    public FieldList getFieldList() {
        return this._fieldList;
    }

    public void setSegmentStart(boolean bl) {
        this.setFieldValue(Field.NEW_SEGMENT, bl ? "1" : null, false);
    }

    public void setMarkedForDeletion(boolean bl) {
        this._markedForDeletion = bl;
    }

    public Coordinate getLatitude() {
        return this._latitude;
    }

    public Coordinate getLongitude() {
        return this._longitude;
    }

    public boolean hasAltitude() {
        return this._altitude.isValid();
    }

    public Altitude getAltitude() {
        return this._altitude;
    }

    public boolean hasTimestamp() {
        return this._timestamp.isValid();
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    public String getWaypointName() {
        return this._waypointName;
    }

    public boolean getSegmentStart() {
        return this._startOfSegment;
    }

    public boolean getDeleteFlag() {
        return this._markedForDeletion;
    }

    public boolean isWaypoint() {
        return this._waypointName != null && !this._waypointName.equals("");
    }

    public boolean isModified() {
        return this._modifyCount > 0;
    }

    public boolean isDuplicate(DataPoint dataPoint) {
        if (dataPoint == null) {
            return false;
        }
        if (this._longitude == null || this._latitude == null || dataPoint._longitude == null || dataPoint._latitude == null) {
            return false;
        }
        if (this._photo != null) {
            return false;
        }
        if (!this._longitude.equals(dataPoint._longitude) || !this._latitude.equals(dataPoint._latitude)) {
            return false;
        }
        if (!this.isWaypoint()) {
            return !dataPoint.isWaypoint();
        }
        return dataPoint._waypointName != null && dataPoint._waypointName.equals(this._waypointName);
    }

    public void setPhoto(Photo photo) {
        this._photo = photo;
    }

    public Photo getPhoto() {
        return this._photo;
    }

    public boolean isValid() {
        return this._latitude.isValid() && this._longitude.isValid();
    }

    public DataPoint[] interpolate(DataPoint dataPoint, int n) {
        DataPoint[] dataPointArray = new DataPoint[n];
        int n2 = 0;
        while (n2 < n) {
            Coordinate coordinate = Coordinate.interpolate(this._latitude, dataPoint.getLatitude(), n2, n);
            Coordinate coordinate2 = Coordinate.interpolate(this._longitude, dataPoint.getLongitude(), n2, n);
            Altitude altitude = Altitude.interpolate(this._altitude, dataPoint.getAltitude(), n2, n);
            dataPointArray[n2] = new DataPoint(coordinate, coordinate2, altitude);
            ++n2;
        }
        return dataPointArray;
    }

    public static DataPoint interpolate(DataPoint dataPoint, DataPoint dataPoint2, double d) {
        if (dataPoint == null || dataPoint2 == null) {
            return null;
        }
        return new DataPoint(Coordinate.interpolate(dataPoint.getLatitude(), dataPoint2.getLatitude(), d), Coordinate.interpolate(dataPoint.getLongitude(), dataPoint2.getLongitude(), d), Altitude.interpolate(dataPoint.getAltitude(), dataPoint2.getAltitude(), d));
    }

    public static double calculateRadiansBetween(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint == null || dataPoint2 == null) {
            return 0.0;
        }
        double d = dataPoint.getLatitude().getDouble() * (Math.PI / 180);
        double d2 = dataPoint2.getLatitude().getDouble() * (Math.PI / 180);
        double d3 = dataPoint.getLongitude().getDouble() * (Math.PI / 180);
        double d4 = dataPoint2.getLongitude().getDouble() * (Math.PI / 180);
        double d5 = Math.sin((d2 - d) / 2.0);
        double d6 = Math.sin((d4 - d3) / 2.0);
        double d7 = Math.cos(d) * Math.cos(d2) * d6 * d6;
        double d8 = 2.0 * Math.asin(Math.sqrt(d5 * d5 + d7));
        return d8;
    }

    private void resizeValueArray(int n) {
        int n2 = n + 1;
        if (n2 > this._fieldValues.length) {
            String[] stringArray = new String[n2];
            System.arraycopy(this._fieldValues, 0, stringArray, 0, this._fieldValues.length);
            this._fieldValues = stringArray;
        }
    }

    public DataPoint clonePoint() {
        String[] stringArray = new String[this._fieldValues.length];
        System.arraycopy(this._fieldValues, 0, stringArray, 0, this._fieldValues.length);
        DataPoint dataPoint = new DataPoint(stringArray, this._fieldList, this._altitude.getFormat());
        return dataPoint;
    }

    public String toString() {
        return "[Lat=" + this.getLatitude().toString() + ", Lon=" + this.getLongitude().toString() + "]";
    }
}

