/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.config.ConfigException;
import tim.prune.gui.DetailsDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.MenuManager;
import tim.prune.gui.ProfileChart;
import tim.prune.gui.SelectorDisplay;
import tim.prune.gui.StatusBar;
import tim.prune.gui.Viewport;
import tim.prune.gui.map.MapCanvas;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GpsPruner {
    public static final String VERSION_NUMBER = "9";
    public static final String BUILD_NUMBER = "178";
    private static App APP = null;

    public static void main(String[] stringArray) {
        Serializable serializable;
        String string;
        Locale locale = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ArrayList<File> arrayList = new ArrayList<File>();
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            string = stringArray[n];
            if (string.startsWith("--locale=")) {
                string2 = string.substring(9);
                locale = GpsPruner.getLanguage(string2);
            } else if (string.startsWith("--lang=")) {
                string2 = string.substring(7);
                locale = GpsPruner.getLanguage(string2);
            } else if (string.startsWith("--langfile=")) {
                string3 = string.substring(11);
            } else if (string.startsWith("--configfile=")) {
                string4 = string.substring(13);
            } else if (string.startsWith("--help")) {
                bl = true;
            } else {
                serializable = new File(string);
                if (((File)serializable).exists() && ((File)serializable).canRead()) {
                    arrayList.add((File)serializable);
                } else {
                    System.out.println("Unknown parameter '" + string + "'.");
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            System.out.println("Possible parameters:\n   --configfile=<file> used to specify a configuration file\n   --lang=<code> or --locale=<code>  used to specify language\n   --langfile=<file>   used to specify an alternative language file\n");
        }
        try {
            if (string4 != null) {
                Config.loadFile(new File(string4));
            } else {
                Config.loadDefaultFile();
            }
        }
        catch (ConfigException configException) {
            System.err.println("Failed to load config file: " + string4);
        }
        int n2 = n = locale != null ? 1 : 0;
        if (n != 0) {
            Config.setConfigString("prune.languagecode", string2);
        } else {
            string = Config.getConfigString("prune.languagecode");
            if (string != null && (serializable = GpsPruner.getLanguage(string)) != null) {
                locale = serializable;
            }
        }
        I18nManager.init(locale);
        if (string3 == null && n == 0) {
            string3 = Config.getConfigString("prune.languagefile");
        }
        if (string3 != null && !string3.equals("")) {
            try {
                I18nManager.addLanguageFile(string3);
                Config.setConfigString("prune.languagefile", string3);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("Failed to load language file: " + string3);
            }
        }
        GpsPruner.launch(arrayList);
    }

    private static Locale getLanguage(String string) {
        if (string.length() == 2) {
            return new Locale(string);
        }
        if (string.length() == 5) {
            return new Locale(string.substring(0, 2), string.substring(3));
        }
        System.out.println("Unrecognised locale '" + string + "' - value should be eg 'DE' or 'DE_ch'");
        return null;
    }

    private static void launch(ArrayList<File> arrayList) {
        JFrame jFrame = new JFrame("Prune");
        APP = new App(jFrame);
        MenuManager menuManager = new MenuManager(APP, APP.getTrackInfo());
        jFrame.setJMenuBar(menuManager.createMenuBar());
        APP.setMenuManager(menuManager);
        UpdateMessageBroker.addSubscriber(menuManager);
        JToolBar jToolBar = menuManager.createToolBar();
        SelectorDisplay selectorDisplay = new SelectorDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(selectorDisplay);
        DetailsDisplay detailsDisplay = new DetailsDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(detailsDisplay);
        MapCanvas mapCanvas = new MapCanvas(APP, APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(mapCanvas);
        Viewport viewport = new Viewport(mapCanvas);
        APP.setViewport(viewport);
        ProfileChart profileChart = new ProfileChart(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(profileChart);
        StatusBar statusBar = new StatusBar();
        UpdateMessageBroker.addSubscriber(statusBar);
        UpdateMessageBroker.informSubscribers("Prune v9");
        JSplitPane jSplitPane = new JSplitPane(0, mapCanvas, profileChart);
        jSplitPane.setResizeWeight(1.0);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, detailsDisplay);
        jSplitPane2.setResizeWeight(1.0);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jToolBar, "North");
        jFrame.getContentPane().add((Component)new JSplitPane(1, selectorDisplay, jSplitPane2), "Center");
        jFrame.getContentPane().add((Component)statusBar, "South");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                APP.exit();
            }
        });
        jFrame.setDefaultCloseOperation(0);
        try {
            jFrame.setIconImage(IconManager.getImageIcon("window_icon.png").getImage());
        }
        catch (Exception exception) {}
        jFrame.pack();
        jFrame.setSize(650, 450);
        jFrame.setVisible(true);
        jSplitPane.setDividerLocation(0.75);
        APP.loadDataFiles(arrayList);
    }
}

