/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.load.GenericFileFilter;
import tim.prune.load.OneCharDocument;
import tim.prune.save.FieldInfo;
import tim.prune.save.FieldSelectionTableModel;
import tim.prune.save.UpDownToggler;

public class FileSaver {
    private App _app = null;
    private JFrame _parentFrame = null;
    private Track _track = null;
    private JDialog _dialog = null;
    private JFileChooser _fileChooser = null;
    private JPanel _cards = null;
    private JButton _nextButton = null;
    private JButton _backButton = null;
    private JTable _table = null;
    private FieldSelectionTableModel _model = null;
    private JButton _moveUpButton = null;
    private JButton _moveDownButton = null;
    private UpDownToggler _toggler = null;
    private JRadioButton[] _delimiterRadios = null;
    private JTextField _otherDelimiterText = null;
    private JCheckBox _headerRowCheckbox = null;
    private JRadioButton[] _coordUnitsRadios = null;
    private JRadioButton[] _altitudeUnitsRadios = null;
    private JRadioButton[] _timestampUnitsRadios = null;
    private static final int[] FORMAT_COORDS = new int[]{19, 10, 11, 12};
    private static final Altitude.Format[] FORMAT_ALTS = new Altitude.Format[]{Altitude.Format.NO_FORMAT, Altitude.Format.METRES, Altitude.Format.FEET};
    private static final int[] FORMAT_TIMES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        FORMAT_TIMES = nArray;
    }

    public FileSaver(App app, JFrame jFrame, Track track) {
        this._app = app;
        this._parentFrame = jFrame;
        this._track = track;
    }

    public void showDialog(char c) {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.saveoptions.title"), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        FieldList fieldList = this._track.getFieldList();
        int n = fieldList.getNumFields();
        this._model = new FieldSelectionTableModel(n);
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldList.getField(n2);
            FieldInfo fieldInfo = new FieldInfo(field, this._track.hasData(field));
            this._model.addFieldInfo(fieldInfo, n2);
            ++n2;
        }
        this.initDialog(this._model, c);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._cards = new JPanel();
        this._cards.setLayout(new CardLayout());
        jPanel.add((Component)this._cards, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this._table = new JTable();
        this._table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        this._table.setPreferredScrollableViewportSize(new Dimension(300, 150));
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel3, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this._moveUpButton = new JButton(I18nManager.getText("button.moveup"));
        this._moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileSaver.this._table.getSelectedRow();
                if (n > 0) {
                    FileSaver.this._model.swapItems(n, n - 1);
                    FileSaver.this._table.setRowSelectionInterval(n - 1, n - 1);
                }
            }
        });
        this._moveUpButton.setEnabled(false);
        jPanel5.add(this._moveUpButton);
        this._moveDownButton = new JButton(I18nManager.getText("button.movedown"));
        this._moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FileSaver.this._table.getSelectedRow();
                if (n > -1 && n < FileSaver.this._model.getRowCount() - 1) {
                    FileSaver.this._model.swapItems(n, n + 1);
                    FileSaver.this._table.setRowSelectionInterval(n + 1, n + 1);
                }
            }
        });
        this._moveDownButton.setEnabled(false);
        jPanel5.add(this._moveDownButton);
        jPanel4.add((Component)jPanel5, "East");
        this._toggler = new UpDownToggler(this._moveUpButton, this._moveDownButton);
        this._table.getSelectionModel().addListSelectionListener(this._toggler);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.save.fieldstosave"));
        jLabel.setAlignmentX(0.0f);
        jPanel2.add(jLabel);
        jPanel4.setAlignmentX(0.0f);
        jPanel2.add(jPanel4);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.delimiter.label"));
        jLabel2.setAlignmentX(0.0f);
        jPanel2.add(jLabel2);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(0, 2));
        jPanel6.setAlignmentX(0.0f);
        this._delimiterRadios = new JRadioButton[5];
        this._delimiterRadios[0] = new JRadioButton(I18nManager.getText("dialog.delimiter.comma"));
        jPanel6.add(this._delimiterRadios[0]);
        this._delimiterRadios[1] = new JRadioButton(I18nManager.getText("dialog.delimiter.tab"));
        jPanel6.add(this._delimiterRadios[1]);
        this._delimiterRadios[2] = new JRadioButton(I18nManager.getText("dialog.delimiter.semicolon"));
        jPanel6.add(this._delimiterRadios[2]);
        this._delimiterRadios[3] = new JRadioButton(I18nManager.getText("dialog.delimiter.space"));
        jPanel6.add(this._delimiterRadios[3]);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout(0, 0, 0));
        this._delimiterRadios[4] = new JRadioButton(I18nManager.getText("dialog.delimiter.other"));
        jPanel7.add(this._delimiterRadios[4]);
        this._otherDelimiterText = new JTextField(new OneCharDocument(), null, 2);
        jPanel7.add(this._otherDelimiterText);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < this._delimiterRadios.length) {
            buttonGroup.add(this._delimiterRadios[n]);
            ++n;
        }
        jPanel6.add(jPanel7);
        jPanel2.add(jPanel6);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 10)));
        this._headerRowCheckbox = new JCheckBox(I18nManager.getText("dialog.save.headerrow"), true);
        jPanel2.add(this._headerRowCheckbox);
        this._cards.add((Component)jPanel2, "card1");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.save.coordinateunits"));
        jLabel3.setAlignmentX(0.0f);
        jPanel9.add(jLabel3);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(BorderFactory.createEtchedBorder());
        jPanel10.setLayout(new GridLayout(0, 2));
        this._coordUnitsRadios = new JRadioButton[4];
        this._coordUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._coordUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.degminsec"));
        this._coordUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.degmin"));
        this._coordUnitsRadios[3] = new JRadioButton(I18nManager.getText("units.deg"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        int n2 = 0;
        while (n2 < 4) {
            buttonGroup2.add(this._coordUnitsRadios[n2]);
            jPanel10.add(this._coordUnitsRadios[n2]);
            this._coordUnitsRadios[n2].setSelected(n2 == 0);
            ++n2;
        }
        jPanel10.setAlignmentX(0.0f);
        jPanel9.add(jPanel10);
        jPanel9.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel4 = new JLabel(I18nManager.getText("dialog.save.altitudeunits"));
        jLabel4.setAlignmentX(0.0f);
        jPanel9.add(jLabel4);
        JPanel jPanel11 = new JPanel();
        jPanel11.setBorder(BorderFactory.createEtchedBorder());
        jPanel11.setLayout(new GridLayout(0, 2));
        this._altitudeUnitsRadios = new JRadioButton[3];
        this._altitudeUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._altitudeUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.metres"));
        this._altitudeUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.feet"));
        ButtonGroup buttonGroup3 = new ButtonGroup();
        int n3 = 0;
        while (n3 < 3) {
            buttonGroup3.add(this._altitudeUnitsRadios[n3]);
            jPanel11.add(this._altitudeUnitsRadios[n3]);
            this._altitudeUnitsRadios[n3].setSelected(n3 == 0);
            ++n3;
        }
        jPanel11.setAlignmentX(0.0f);
        jPanel9.add(jPanel11);
        jPanel9.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel5 = new JLabel(I18nManager.getText("dialog.save.timestampformat"));
        jLabel5.setAlignmentX(0.0f);
        jPanel9.add(jLabel5);
        JPanel jPanel12 = new JPanel();
        jPanel12.setBorder(BorderFactory.createEtchedBorder());
        jPanel12.setLayout(new GridLayout(0, 2));
        this._timestampUnitsRadios = new JRadioButton[3];
        this._timestampUnitsRadios[0] = new JRadioButton(I18nManager.getText("units.original"));
        this._timestampUnitsRadios[1] = new JRadioButton(I18nManager.getText("units.default"));
        this._timestampUnitsRadios[2] = new JRadioButton(I18nManager.getText("units.iso8601"));
        ButtonGroup buttonGroup4 = new ButtonGroup();
        int n4 = 0;
        while (n4 < 3) {
            buttonGroup4.add(this._timestampUnitsRadios[n4]);
            jPanel12.add(this._timestampUnitsRadios[n4]);
            this._timestampUnitsRadios[n4].setSelected(n4 == 0);
            ++n4;
        }
        jPanel12.setAlignmentX(0.0f);
        jPanel9.add(jPanel12);
        jPanel8.add((Component)jPanel9, "North");
        this._cards.add((Component)jPanel8, "card2");
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new FlowLayout(2));
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardLayout cardLayout = (CardLayout)FileSaver.this._cards.getLayout();
                cardLayout.previous(FileSaver.this._cards);
                FileSaver.this._backButton.setEnabled(false);
                FileSaver.this._nextButton.setEnabled(true);
            }
        });
        this._backButton.setEnabled(false);
        jPanel13.add(this._backButton);
        this._nextButton = new JButton(I18nManager.getText("button.next"));
        this._nextButton.setEnabled(true);
        this._nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardLayout cardLayout = (CardLayout)FileSaver.this._cards.getLayout();
                cardLayout.next(FileSaver.this._cards);
                FileSaver.this._backButton.setEnabled(true);
                FileSaver.this._nextButton.setEnabled(false);
            }
        });
        jPanel13.add(this._nextButton);
        JButton jButton = new JButton(I18nManager.getText("button.finish"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSaver.this.saveToFile()) {
                    FileSaver.this._dialog.dispose();
                }
            }
        });
        jPanel13.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSaver.this._dialog.dispose();
            }
        });
        jPanel13.add(jButton2);
        jPanel.add((Component)jPanel13, "South");
        return jPanel;
    }

    private void initDialog(TableModel tableModel, char c) {
        this._table.setModel(tableModel);
        this._toggler.setListSize(tableModel.getRowCount());
        switch (c) {
            case ',': {
                this._delimiterRadios[0].setSelected(true);
                break;
            }
            case '\t': {
                this._delimiterRadios[1].setSelected(true);
                break;
            }
            case ';': {
                this._delimiterRadios[2].setSelected(true);
                break;
            }
            case ' ': {
                this._delimiterRadios[3].setSelected(true);
                break;
            }
            default: {
                this._delimiterRadios[4].setSelected(true);
                this._otherDelimiterText.setText("" + c);
            }
        }
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        cardLayout.first(this._cards);
        this._nextButton.setEnabled(true);
        this._backButton.setEnabled(false);
    }

    private boolean saveToFile() {
        boolean bl;
        block47: {
            File file;
            bl = true;
            FileWriter fileWriter = null;
            if (this._fileChooser == null) {
                this._fileChooser = new JFileChooser();
                this._fileChooser.setDialogType(1);
                this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.txt", new String[]{"txt", "text"}));
                this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
                this._fileChooser.addChoosableFileFilter(new GenericFileFilter("filetype.kml", new String[]{"kml"}));
                this._fileChooser.setAcceptAllFileFilterUsed(true);
                file = Config.getWorkingDirectory();
                if (file != null) {
                    this._fileChooser.setCurrentDirectory(file);
                }
            }
            if (this._fileChooser.showSaveDialog(this._parentFrame) == 0) {
                file = this._fileChooser.getSelectedFile();
                String string = System.getProperty("line.separator");
                int n = 19;
                int n2 = 0;
                while (n2 < this._coordUnitsRadios.length) {
                    if (this._coordUnitsRadios[n2].isSelected()) {
                        n = FORMAT_COORDS[n2];
                    }
                    ++n2;
                }
                Altitude.Format format = Altitude.Format.NO_FORMAT;
                int n3 = 0;
                while (n3 < this._altitudeUnitsRadios.length) {
                    if (this._altitudeUnitsRadios[n3].isSelected()) {
                        format = FORMAT_ALTS[n3];
                    }
                    ++n3;
                }
                n3 = 0;
                int n4 = 0;
                while (n4 < this._timestampUnitsRadios.length) {
                    if (this._timestampUnitsRadios[n4].isSelected()) {
                        n3 = FORMAT_TIMES[n4];
                    }
                    ++n4;
                }
                Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
                if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                    try {
                        try {
                            int n5;
                            fileWriter = new FileWriter(file);
                            char c = this.getDelimiter();
                            FieldInfo fieldInfo = null;
                            Field field = null;
                            StringBuffer stringBuffer = null;
                            int n6 = this._model.getRowCount();
                            boolean bl2 = true;
                            if (this._headerRowCheckbox.isSelected()) {
                                stringBuffer = new StringBuffer();
                                n5 = 0;
                                while (n5 < n6) {
                                    fieldInfo = this._model.getFieldInfo(n5);
                                    if (fieldInfo.isSelected()) {
                                        if (!bl2) {
                                            stringBuffer.append(c);
                                        }
                                        field = fieldInfo.getField();
                                        stringBuffer.append(field.getName());
                                        bl2 = false;
                                    }
                                    ++n5;
                                }
                                fileWriter.write(stringBuffer.toString());
                                fileWriter.write(string);
                            }
                            n5 = this._track.getNumPoints();
                            int n7 = 0;
                            while (n7 < n5) {
                                DataPoint dataPoint = this._track.getPoint(n7);
                                bl2 = true;
                                stringBuffer = new StringBuffer();
                                int n8 = 0;
                                while (n8 < n6) {
                                    fieldInfo = this._model.getFieldInfo(n8);
                                    if (fieldInfo.isSelected()) {
                                        if (!bl2) {
                                            stringBuffer.append(c);
                                        }
                                        if ((field = fieldInfo.getField()) == Field.LATITUDE) {
                                            stringBuffer.append(dataPoint.getLatitude().output(n));
                                        } else if (field == Field.LONGITUDE) {
                                            stringBuffer.append(dataPoint.getLongitude().output(n));
                                        } else if (field == Field.ALTITUDE) {
                                            try {
                                                stringBuffer.append(dataPoint.getAltitude().getStringValue(format));
                                            }
                                            catch (NullPointerException nullPointerException) {}
                                        } else if (field == Field.TIMESTAMP) {
                                            if (dataPoint.hasTimestamp()) {
                                                if (n3 == 0) {
                                                    stringBuffer.append(dataPoint.getFieldValue(Field.TIMESTAMP));
                                                } else {
                                                    stringBuffer.append(dataPoint.getTimestamp().getText(n3));
                                                }
                                            }
                                        } else {
                                            String string2 = dataPoint.getFieldValue(field);
                                            if (string2 != null) {
                                                stringBuffer.append(string2);
                                            }
                                        }
                                        bl2 = false;
                                    }
                                    ++n8;
                                }
                                fileWriter.write(stringBuffer.toString());
                                fileWriter.write(string);
                                ++n7;
                            }
                            Config.setWorkingDirectory(file.getParentFile());
                            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n5 + " " + I18nManager.getText("confirm.save.ok2") + " " + file.getAbsolutePath());
                            this._app.informDataSaved();
                        }
                        catch (IOException iOException) {
                            bl = false;
                            this._app.showErrorMessageNoLookup("error.save.dialogtitle", String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
                            try {
                                if (fileWriter != null) {
                                    fileWriter.close();
                                }
                                break block47;
                            }
                            catch (Exception exception) {}
                            break block47;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fileWriter != null) {
                                fileWriter.close();
                            }
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (fileWriter != null) {
                            fileWriter.close();
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private char getDelimiter() {
        char[] cArray = new char[]{',', '\t', ';', ' '};
        int n = 0;
        while (n < 4) {
            if (this._delimiterRadios[n].isSelected()) {
                return cArray[n];
            }
            ++n;
        }
        return this._otherDelimiterText.getText().charAt(0);
    }
}

