/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;

public class GpsLoader
extends GenericFunction
implements Runnable {
    private boolean _gpsBabelChecked = false;
    private JDialog _dialog = null;
    private JTextField _deviceField = null;
    private JTextField _formatField = null;
    private JCheckBox _waypointCheckbox = null;
    private JCheckBox _trackCheckbox = null;
    private JButton _okButton = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;

    public GpsLoader(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.loadfromgps";
    }

    public void begin() {
        if (this._gpsBabelChecked || ExternalTools.isGpsbabelInstalled() || JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.gpsload.nogpsbabel"), I18nManager.getText(this.getNameKey()), 0, 2) == 0) {
            this._gpsBabelChecked = true;
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this.enableOkButton();
            this.setupProgressBar(true);
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(Config.getGpsDevice(), 12);
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(Config.getGpsFormat(), 12);
        jPanel3.add(this._formatField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GpsLoader.this.enableOkButton();
            }
        };
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.getwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.gettracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsLoader.this._cancelled = false;
                new Thread(GpsLoader.this).start();
            }
        });
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsLoader.this._cancelled = true;
                GpsLoader.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void setupProgressBar(boolean bl) {
        this._progressBar.setVisible(!bl);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
    }

    private void enableOkButton() {
        this._okButton.setEnabled(this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected());
    }

    public void run() {
        this._okButton.setEnabled(false);
        this.setupProgressBar(false);
        if (this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected()) {
            this._progressBar.setIndeterminate(true);
            try {
                this.callGpsBabel(this._waypointCheckbox.isSelected(), this._trackCheckbox.isSelected());
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), exception.getMessage());
                this._cancelled = true;
            }
        }
        this.setupProgressBar(true);
        this.enableOkButton();
        if (!this._cancelled) {
            this._dialog.dispose();
        }
    }

    private void callGpsBabel(boolean bl, boolean bl2) throws Exception {
        Object object;
        Object object2;
        String[] stringArray = null;
        if (bl && bl2) {
            stringArray = new String[]{"gpsbabel", "-w", "-t", "-i", this._formatField.getText(), "-f", this._deviceField.getText(), "-o", "gpx", "-F", "-"};
        } else {
            stringArray = new String[]{"gpsbabel", "-w", "-i", this._formatField.getText(), "-f", this._deviceField.getText(), "-o", "gpx", "-F", "-"};
            if (bl2) {
                stringArray[1] = "-t";
            }
        }
        String string = "";
        XmlHandler xmlHandler = null;
        Process process = Runtime.getRuntime().exec(stringArray);
        try {
            object2 = new XmlFileLoader(this._app);
            object = SAXParserFactory.newInstance().newSAXParser();
            ((SAXParser)object).parse(process.getInputStream(), (DefaultHandler)object2);
            xmlHandler = ((XmlFileLoader)object2).getHandler();
            if (xmlHandler == null) {
                string = "Null handler";
            }
        }
        catch (Exception exception) {
            string = exception.getMessage();
        }
        object2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        object = null;
        String string2 = "";
        while ((object = ((BufferedReader)object2).readLine()) != null) {
            string2 = String.valueOf(string2) + (String)object + "\n";
        }
        try {
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {}
        if (string2.length() > 0) {
            string = string2;
        }
        if (string.length() > 0) {
            throw new Exception(string);
        }
        this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), Altitude.Format.METRES, this._deviceField.getText());
    }
}

