/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.data.DoubleRange;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.IconManager;
import tim.prune.gui.map.MapPosition;
import tim.prune.gui.map.MapTileCacher;
import tim.prune.gui.map.MapTileConfig;
import tim.prune.gui.map.MapUtils;

public class MapCanvas
extends JPanel
implements MouseListener,
MouseMotionListener,
DataSubscriber,
KeyListener,
MouseWheelListener {
    private App _app = null;
    private Track _track = null;
    private Selection _selection = null;
    private int _prevSelectedPoint = -1;
    private MapTileCacher _tileCacher = new MapTileCacher(this);
    private BufferedImage _mapImage = null;
    private JSlider _transparencySlider = null;
    private JCheckBox _mapCheckBox = null;
    private JCheckBox _autopanCheckBox = null;
    private JCheckBox _connectCheckBox = null;
    private JPopupMenu _popup = null;
    private JPanel _topPanel = null;
    private JPanel _sidePanel = null;
    private DoubleRange _latRange = null;
    private DoubleRange _lonRange = null;
    private DoubleRange _xRange = null;
    private DoubleRange _yRange = null;
    private boolean _recalculate = false;
    private boolean _checkBounds = false;
    private MapPosition _mapPosition = null;
    private int _dragFromX = -1;
    private int _dragFromY = -1;
    private boolean _zoomDragging = false;
    private int _dragToX = -1;
    private int _dragToY = -1;
    private int _popupMenuX = -1;
    private int _popupMenuY = -1;
    private boolean _shownOsmErrorAlready = false;
    private static final int CLICK_SENSITIVITY = 10;
    private static final int PAN_DISTANCE = 20;
    private static final int AUTOPAN_DISTANCE = 75;
    private static final Color COLOR_BG = Color.WHITE;
    private static final Color COLOR_MESSAGES = Color.GRAY;
    private static final Color COLOR_POINT = Color.BLUE;
    private static final Color COLOR_POINT_DELETED = Color.RED;
    private static final Color COLOR_CURR_RANGE = Color.GREEN;
    private static final Color COLOR_CROSSHAIRS = Color.RED;
    private static final Color COLOR_WAYPT_NAME = Color.BLACK;
    private static final Color COLOR_PHOTO_PT = Color.ORANGE;

    public MapCanvas(App app, TrackInfo trackInfo) {
        this._app = app;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
        this._mapPosition = new MapPosition();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                MapCanvas.this._tileCacher.clearAll();
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        };
        this._topPanel = new JPanel();
        this._topPanel.setLayout(new FlowLayout());
        this._topPanel.setOpaque(false);
        this._transparencySlider = new JSlider(0, 5, 0);
        this._transparencySlider.setPreferredSize(new Dimension(100, 20));
        this._transparencySlider.setMajorTickSpacing(1);
        this._transparencySlider.setSnapToTicks(true);
        this._transparencySlider.setOpaque(false);
        this._transparencySlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        });
        this._transparencySlider.setFocusable(false);
        this._topPanel.add(this._transparencySlider);
        this._mapCheckBox = new JCheckBox(IconManager.getImageIcon("map_icon.gif"), false);
        this._mapCheckBox.setSelectedIcon(IconManager.getImageIcon("map_icon_on.gif"));
        this._mapCheckBox.setOpaque(false);
        this._mapCheckBox.setToolTipText(I18nManager.getText("menu.map.showmap"));
        this._mapCheckBox.addItemListener(itemListener2);
        this._mapCheckBox.setFocusable(false);
        this._topPanel.add(this._mapCheckBox);
        this._autopanCheckBox = new JCheckBox(IconManager.getImageIcon("autopan.gif"), true);
        this._autopanCheckBox.setSelectedIcon(IconManager.getImageIcon("autopan_on.gif"));
        this._autopanCheckBox.setOpaque(false);
        this._autopanCheckBox.setToolTipText(I18nManager.getText("menu.map.autopan"));
        this._autopanCheckBox.addItemListener(itemListener);
        this._autopanCheckBox.setFocusable(false);
        this._topPanel.add(this._autopanCheckBox);
        this._connectCheckBox = new JCheckBox(IconManager.getImageIcon("points_disconnected.gif"), true);
        this._connectCheckBox.setSelectedIcon(IconManager.getImageIcon("points_connected.gif"));
        this._connectCheckBox.setOpaque(false);
        this._connectCheckBox.setToolTipText(I18nManager.getText("menu.map.connect"));
        this._connectCheckBox.addItemListener(itemListener);
        this._connectCheckBox.setFocusable(false);
        this._topPanel.add(this._connectCheckBox);
        this._sidePanel = new JPanel();
        this._sidePanel.setLayout(new BoxLayout(this._sidePanel, 1));
        this._sidePanel.setOpaque(false);
        JButton jButton = new JButton(IconManager.getImageIcon("zoom_in.gif"));
        jButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jButton.setContentAreaFilled(false);
        jButton.setToolTipText(I18nManager.getText("menu.map.zoomin"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomIn();
            }
        });
        jButton.setFocusable(false);
        this._sidePanel.add(jButton);
        JButton jButton2 = new JButton(IconManager.getImageIcon("zoom_out.gif"));
        jButton2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jButton2.setContentAreaFilled(false);
        jButton2.setToolTipText(I18nManager.getText("menu.map.zoomout"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomOut();
            }
        });
        jButton2.setFocusable(false);
        this._sidePanel.add(jButton2);
        this.setLayout(new BorderLayout());
        this._topPanel.setVisible(false);
        this._sidePanel.setVisible(false);
        this.add((Component)this._topPanel, "North");
        this.add((Component)this._sidePanel, "West");
        this.makePopup();
    }

    private void makePopup() {
        this._popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("menu.map.zoomin"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomIn();
            }
        });
        jMenuItem.setEnabled(true);
        this._popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("menu.map.zoomout"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomOut();
            }
        });
        jMenuItem2.setEnabled(true);
        this._popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(I18nManager.getText("menu.map.zoomfull"));
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this.zoomToFit();
                MapCanvas.this._recalculate = true;
                MapCanvas.this.repaint();
            }
        });
        jMenuItem3.setEnabled(true);
        this._popup.add(jMenuItem3);
        this._popup.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(I18nManager.getText(FunctionLibrary.FUNCTION_SET_MAP_BG.getNameKey()));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_SET_MAP_BG.begin();
            }
        });
        this._popup.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(I18nManager.getText("menu.map.newpoint"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MapCanvas.this._app.createPoint(MapUtils.getLatitudeFromY(MapCanvas.this._mapPosition.getYFromPixels(MapCanvas.this._popupMenuY, MapCanvas.this.getHeight())), MapUtils.getLongitudeFromX(MapCanvas.this._mapPosition.getXFromPixels(MapCanvas.this._popupMenuX, MapCanvas.this.getWidth())));
            }
        });
        jMenuItem5.setEnabled(true);
        this._popup.add(jMenuItem5);
    }

    private void zoomToFit() {
        this._latRange = this._track.getLatRange();
        this._lonRange = this._track.getLonRange();
        this._xRange = new DoubleRange(MapUtils.getXFromLongitude(this._lonRange.getMinimum()), MapUtils.getXFromLongitude(this._lonRange.getMaximum()));
        this._yRange = new DoubleRange(MapUtils.getYFromLatitude(this._latRange.getMinimum()), MapUtils.getYFromLatitude(this._latRange.getMaximum()));
        this._mapPosition.zoomToXY(this._xRange.getMinimum(), this._xRange.getMaximum(), this._yRange.getMinimum(), this._yRange.getMaximum(), this.getWidth(), this.getHeight());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this._mapImage != null && (this._mapImage.getWidth() != this.getWidth() || this._mapImage.getHeight() != this.getHeight())) {
            this._mapImage = null;
        }
        if (this._track.getNumPoints() > 0) {
            if (this._autopanCheckBox.isSelected()) {
                int n = this._selection.getCurrentPointIndex();
                if (n >= 0 && this._dragFromX == -1 && n != this._prevSelectedPoint) {
                    int n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n));
                    int n3 = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n));
                    int n4 = 0;
                    int n5 = 0;
                    if (n2 < 20) {
                        n4 = n2 - 75;
                    } else if (n2 > this.getWidth() - 20) {
                        n4 = 75 + n2 - this.getWidth();
                    }
                    if (n3 < 20) {
                        n5 = n3 - 75;
                    }
                    if (n3 > this.getHeight() - 20) {
                        n5 = 75 + n3 - this.getHeight();
                    }
                    if (n4 != 0 || n5 != 0) {
                        this._mapPosition.pan(n4, n5);
                    }
                }
                this._prevSelectedPoint = n;
            }
            if (this._mapImage == null || this._recalculate) {
                this.getMapTiles();
            }
            if (this._mapImage != null) {
                graphics.drawImage(this._mapImage, 0, 0, this.getWidth(), this.getHeight(), null);
            }
            if (this._zoomDragging) {
                graphics.setColor(Color.RED);
                graphics.drawLine(this._dragFromX, this._dragFromY, this._dragFromX, this._dragToY);
                graphics.drawLine(this._dragFromX, this._dragFromY, this._dragToX, this._dragFromY);
                graphics.drawLine(this._dragToX, this._dragFromY, this._dragToX, this._dragToY);
                graphics.drawLine(this._dragFromX, this._dragToY, this._dragToX, this._dragToY);
            }
        } else {
            graphics.setColor(COLOR_BG);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(COLOR_MESSAGES);
            graphics.drawString(I18nManager.getText("display.nodata"), 50, this.getHeight() / 2);
        }
        this.paintChildren(graphics);
    }

    private void getMapTiles() {
        int n;
        if (this._mapImage == null || this._mapImage.getWidth() != this.getWidth() || this._mapImage.getHeight() != this.getHeight()) {
            this._mapImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        }
        Graphics graphics = this._mapImage.getGraphics();
        graphics.setColor(COLOR_BG);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this._mapCheckBox.isSelected()) {
            this._shownOsmErrorAlready = false;
        }
        if (this._mapCheckBox.isSelected()) {
            this._tileCacher.centreMap(this._mapPosition.getZoom(), this._mapPosition.getCentreTileX(), this._mapPosition.getCentreTileY());
            n = 0;
            if (this._mapImage == null) {
                return;
            }
            if (this._tileCacher.isOverzoomed()) {
                graphics.setColor(COLOR_MESSAGES);
                graphics.drawString(I18nManager.getText("map.overzoom"), 50, this.getHeight() / 2);
            } else {
                int[] nArray = this._mapPosition.getTileIndices(this.getWidth(), this.getHeight());
                int[] nArray2 = this._mapPosition.getDisplayOffsets(this.getWidth(), this.getHeight());
                int n2 = nArray[0];
                while (n2 <= nArray[1] && n == 0) {
                    int n3 = (n2 - nArray[0]) * 256 - nArray2[0];
                    int n4 = nArray[2];
                    while (n4 <= nArray[3]) {
                        int n5 = (n4 - nArray[2]) * 256 - nArray2[1];
                        Image image = this._tileCacher.getTile(n2, n4);
                        if (image != null) {
                            graphics.drawImage(image, n3, n5, 256, 256, null);
                        }
                        ++n4;
                    }
                    ++n2;
                }
                float[] fArray = new float[]{1.0f, 1.05f, 1.1f, 1.2f, 1.6f, 2.0f};
                float[] fArray2 = fArray;
                float f = fArray2[this._transparencySlider.getValue()];
                if (f > 1.0f) {
                    RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                    renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    RescaleOp rescaleOp = new RescaleOp(f, 0.0f, renderingHints);
                    rescaleOp.filter(this._mapImage, this._mapImage);
                }
            }
        }
        n = 1;
        try {
            n = this.paintPoints(graphics);
        }
        catch (NullPointerException nullPointerException) {}
        graphics.dispose();
        this._recalculate = false;
        if (n <= 0 && this._checkBounds) {
            this.zoomToFit();
            this._recalculate = true;
            this.repaint();
        }
        this._checkBounds = false;
        this._transparencySlider.setEnabled(this._mapCheckBox.isSelected());
    }

    private int paintPoints(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        graphics.setColor(COLOR_POINT);
        int n6 = -1;
        int n7 = -1;
        boolean bl = this._connectCheckBox.isSelected();
        boolean bl2 = false;
        boolean bl3 = false;
        int n8 = 0;
        while (n8 < this._track.getNumPoints()) {
            n4 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n8));
            n3 = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n8));
            boolean bl4 = bl3 = n4 >= 0 && n4 < this.getWidth() && n3 >= 0 && n3 < this.getHeight();
            if (bl3 && !this._track.getPoint(n8).isWaypoint()) {
                if (this._track.getPoint(n8).getDeleteFlag()) {
                    graphics.setColor(COLOR_POINT_DELETED);
                } else {
                    graphics.setColor(COLOR_POINT);
                }
                graphics.drawRect(n4 - 2, n3 - 2, 3, 3);
                ++n5;
            }
            if (!this._track.getPoint(n8).isWaypoint()) {
                if (bl && (bl3 || bl2) && (n6 != -1 || n7 != -1) && !this._track.getPoint(n8).getSegmentStart()) {
                    graphics.drawLine(n6, n7, n4, n3);
                }
                n6 = n4;
                n7 = n3;
            }
            bl2 = bl3;
            ++n8;
        }
        graphics.setColor(COLOR_WAYPT_NAME);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        n4 = fontMetrics.getHeight();
        n3 = this.getWidth();
        int n9 = this.getHeight();
        int n10 = 0;
        while (n10 < this._track.getNumPoints()) {
            if (this._track.getPoint(n10).isWaypoint()) {
                n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n10));
                n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n10));
                if (n2 >= 0 && n2 < this.getWidth() && n >= 0 && n < this.getHeight()) {
                    graphics.fillRect(n2 - 3, n - 3, 6, 6);
                    ++n5;
                }
            }
            ++n10;
        }
        n10 = 0;
        while (n10 < this._track.getNumPoints()) {
            if (this._track.getPoint(n10).isWaypoint()) {
                n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n10));
                n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n10));
                if (n2 >= 0 && n2 < this.getWidth() && n >= 0 && n < this.getHeight()) {
                    String string = this._track.getPoint(n10).getWaypointName();
                    int n11 = fontMetrics.stringWidth(string);
                    boolean bl5 = false;
                    int[] nArray = new int[]{n2 + 2, n2 - n11 - 2, n2 - n11 / 2, n2 - n11 / 2};
                    int[] nArray2 = new int[]{n + n4 / 2, n + n4 / 2, n - 2, n + n4 + 2};
                    int n12 = 4;
                    while (n12 < 13 && !bl5) {
                        nArray[0] = nArray[0] + 2;
                        nArray[1] = nArray[1] - 2;
                        nArray2[2] = nArray2[2] - 2;
                        nArray2[3] = nArray2[3] + 2;
                        int n13 = 0;
                        while (n13 < 4) {
                            if (nArray[n13] > 0 && nArray[n13] + n11 < n3 && nArray2[n13] < n9 && nArray2[n13] - n4 > 0 && !this.overlapsPoints(nArray[n13], nArray2[n13], n11, n4)) {
                                graphics.drawString(string, nArray[n13], nArray2[n13]);
                                bl5 = true;
                                break;
                            }
                            ++n13;
                        }
                        n12 += 2;
                    }
                }
            }
            ++n10;
        }
        graphics.setColor(COLOR_PHOTO_PT);
        n10 = 0;
        while (n10 < this._track.getNumPoints()) {
            if (this._track.getPoint(n10).getPhoto() != null) {
                n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n10));
                n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n10));
                if (n2 >= 0 && n2 < this.getWidth() && n >= 0 && n < this.getHeight()) {
                    graphics.drawRect(n2 - 1, n - 1, 2, 2);
                    graphics.drawRect(n2 - 2, n - 2, 4, 4);
                    ++n5;
                }
            }
            ++n10;
        }
        if (this._selection.hasRangeSelected()) {
            graphics.setColor(COLOR_CURR_RANGE);
            n10 = this._selection.getStart();
            while (n10 <= this._selection.getEnd()) {
                n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n10));
                n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n10));
                graphics.drawRect(n2 - 1, n - 1, 2, 2);
                ++n10;
            }
        }
        if ((n10 = this._selection.getCurrentPointIndex()) >= 0) {
            n2 = this.getWidth() / 2 + this._mapPosition.getXFromCentre(this._track.getX(n10));
            n = this.getHeight() / 2 + this._mapPosition.getYFromCentre(this._track.getY(n10));
            graphics.setColor(COLOR_CROSSHAIRS);
            graphics.drawLine(n2, 0, n2, this.getHeight());
            graphics.drawLine(0, n, this.getWidth(), n);
            graphics.drawOval(n2 - 2, n - 2, 4, 4);
            graphics.drawOval(n2 - 3, n - 3, 6, 6);
        }
        return n5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean overlapsPoints(int n, int n2, int n3, int n4) {
        try {
            int n5 = 0;
            block2: while (true) {
                if (n5 >= n3) {
                    return false;
                }
                int n6 = 0;
                while (true) {
                    if (n6 >= n4) {
                        ++n5;
                        continue block2;
                    }
                    int n7 = this._mapImage.getRGB(n + n5, n2 - n6);
                    int n8 = n7 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 >> 16 & 0xFF;
                    if (n8 < 210) return true;
                    if (n9 < 210) return true;
                    if (n10 < 210) {
                        return true;
                    }
                    ++n6;
                }
                break;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return false;
    }

    public synchronized void tilesUpdated(boolean bl) {
        if (!bl && !this._shownOsmErrorAlready && this._mapCheckBox.isSelected()) {
            this._shownOsmErrorAlready = true;
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    MapCanvas.this._app.showErrorMessage("error.osmimage.dialogtitle", "error.osmimage.failed");
                }
            }).start();
        }
        this._recalculate = true;
        this.repaint();
    }

    public void zoomOut() {
        this._mapPosition.zoomOut();
        this._recalculate = true;
        this.repaint();
    }

    public void zoomIn() {
        this._mapPosition.zoomIn();
        this._recalculate = true;
        this.repaint();
    }

    public void panMap(int n, int n2) {
        this._mapPosition.pan(n, n2);
        this._recalculate = true;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(512, 300);
        return dimension;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._track != null && this._track.getNumPoints() > 0) {
            if (!mouseEvent.isMetaDown()) {
                int n = this._track.getNearestPointIndex(this._mapPosition.getXFromPixels(mouseEvent.getX(), this.getWidth()), this._mapPosition.getYFromPixels(mouseEvent.getY(), this.getHeight()), this._mapPosition.getBoundsFromPixels(10), false);
                this._selection.selectPoint(n);
            } else {
                this._popupMenuX = mouseEvent.getX();
                this._popupMenuY = mouseEvent.getY();
                this._popup.show(this, this._popupMenuX, this._popupMenuY);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._recalculate = true;
        if (this._zoomDragging && Math.abs(this._dragToX - this._dragFromX) > 20 && Math.abs(this._dragToY - this._dragFromY) > 20) {
            this._mapPosition.zoomToPixels(this._dragFromX, this._dragToX, this._dragFromY, this._dragToY, this.getWidth(), this.getHeight());
        }
        this._dragFromY = -1;
        this._dragFromX = -1;
        this._zoomDragging = false;
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!mouseEvent.isMetaDown()) {
            this._zoomDragging = false;
            if (this._dragFromX != -1) {
                this.panMap(this._dragFromX - mouseEvent.getX(), this._dragFromY - mouseEvent.getY());
                this._recalculate = true;
                this.repaint();
            }
            this._dragFromX = mouseEvent.getX();
            this._dragFromY = mouseEvent.getY();
        } else {
            this._zoomDragging = true;
            if (this._dragFromX == -1) {
                this._dragFromX = mouseEvent.getX();
                this._dragFromY = mouseEvent.getY();
            }
            this._dragToX = mouseEvent.getX();
            this._dragToY = mouseEvent.getY();
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void actionCompleted(String string) {
    }

    public void dataUpdated(byte by) {
        this._recalculate = true;
        if ((by & 1) > 0) {
            this._checkBounds = true;
        }
        if ((by & 0x40) > 0) {
            this._tileCacher.setTileConfig(new MapTileConfig());
        }
        this.repaint();
        boolean bl = this._track.getNumPoints() > 0;
        this._topPanel.setVisible(bl);
        this._sidePanel.setVisible(bl);
        this.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (keyEvent.isControlDown()) {
            if (n == 38) {
                this.zoomIn();
            } else if (n == 40) {
                this.zoomOut();
            } else if (n == 37) {
                this._selection.selectPreviousPoint();
            } else if (n == 39) {
                this._selection.selectNextPoint();
            }
        } else {
            int n2 = 0;
            if (n == 38) {
                n2 = -20;
            } else if (n == 40) {
                n2 = 20;
            }
            int n3 = 0;
            if (n == 39) {
                n3 = 20;
            } else if (n == 37) {
                n3 = -20;
            }
            this.panMap(n3, n2);
            if (n == 127 && this._selection.getCurrentPointIndex() >= 0) {
                this._app.deleteCurrentPoint();
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (n < 0) {
            this.zoomIn();
        } else if (n > 0) {
            this.zoomOut();
        }
    }
}

