/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import tim.prune.App;
import tim.prune.DataSubscriber;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.data.PhotoList;
import tim.prune.data.Selection;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.function.RearrangeWaypointsFunction;
import tim.prune.gui.IconManager;

public class MenuManager
implements DataSubscriber {
    private App _app = null;
    private Track _track = null;
    private Selection _selection = null;
    private PhotoList _photos = null;
    private JMenuItem _sendGpsItem = null;
    private JMenuItem _saveItem = null;
    private JMenuItem _exportKmlItem = null;
    private JMenuItem _exportGpxItem = null;
    private JMenuItem _exportPovItem = null;
    private JMenuItem _undoItem = null;
    private JMenuItem _clearUndoItem = null;
    private JMenuItem _editPointItem = null;
    private JMenuItem _editWaypointNameItem = null;
    private JMenuItem _deletePointItem = null;
    private JMenuItem _deleteRangeItem = null;
    private JMenuItem _compressItem = null;
    private JMenuItem _deleteMarkedPointsItem = null;
    private JMenuItem _interpolateItem = null;
    private JMenuItem _averageItem = null;
    private JMenuItem _selectAllItem = null;
    private JMenuItem _selectNoneItem = null;
    private JMenuItem _selectStartItem = null;
    private JMenuItem _selectEndItem = null;
    private JMenuItem _reverseItem = null;
    private JMenuItem _addTimeOffsetItem = null;
    private JMenuItem _mergeSegmentsItem = null;
    private JMenu _rearrangeMenu = null;
    private JMenuItem _cutAndMoveItem = null;
    private JMenuItem _show3dItem = null;
    private JMenu _browserMapMenu = null;
    private JMenuItem _chartItem = null;
    private JMenuItem _distanceItem = null;
    private JMenuItem _saveExifItem = null;
    private JMenuItem _connectPhotoItem = null;
    private JMenuItem _deletePhotoItem = null;
    private JMenuItem _disconnectPhotoItem = null;
    private JMenuItem _correlatePhotosItem = null;
    private ActionListener _openFileAction = null;
    private ActionListener _addPhotoAction = null;
    private ActionListener _saveAction = null;
    private ActionListener _undoAction = null;
    private ActionListener _editPointAction = null;
    private ActionListener _deletePointAction = null;
    private ActionListener _deleteRangeAction = null;
    private ActionListener _selectStartAction = null;
    private ActionListener _selectEndAction = null;
    private ActionListener _connectPhotoAction = null;
    private JButton _saveButton = null;
    private JButton _undoButton = null;
    private JButton _editPointButton = null;
    private JButton _deletePointButton = null;
    private JButton _deleteRangeButton = null;
    private JButton _selectStartButton = null;
    private JButton _selectEndButton = null;
    private JButton _connectPhotoButton = null;

    public MenuManager(App app, TrackInfo trackInfo) {
        this._app = app;
        this._track = trackInfo.getTrack();
        this._selection = trackInfo.getSelection();
        this._photos = trackInfo.getPhotoList();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(I18nManager.getText("menu.file"));
        JMenuItem jMenuItem = new JMenuItem(I18nManager.getText("menu.file.open"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this._openFileAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.openFile();
            }
        };
        jMenuItem.addActionListener(this._openFileAction);
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        this._addPhotoAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.addPhotos();
            }
        };
        jMenuItem2.addActionListener(this._addPhotoAction);
        jMenu.add(jMenuItem2);
        jMenu.addSeparator();
        JMenuItem jMenuItem3 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSLOAD);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_GPSLOAD.begin();
            }
        });
        jMenu.add(jMenuItem3);
        this._sendGpsItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPSSAVE);
        this._sendGpsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_GPSSAVE.begin();
            }
        });
        this._sendGpsItem.setEnabled(false);
        jMenu.add(this._sendGpsItem);
        jMenu.addSeparator();
        this._saveItem = new JMenuItem(I18nManager.getText("menu.file.save"), 83);
        this._saveAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveFile();
            }
        };
        this._saveItem.addActionListener(this._saveAction);
        this._saveItem.setEnabled(false);
        jMenu.add(this._saveItem);
        this._exportKmlItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_KMLEXPORT);
        this._exportKmlItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_KMLEXPORT.begin();
            }
        });
        this._exportKmlItem.setEnabled(false);
        jMenu.add(this._exportKmlItem);
        this._exportGpxItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_GPXEXPORT);
        this._exportGpxItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_GPXEXPORT.begin();
            }
        });
        this._exportGpxItem.setEnabled(false);
        jMenu.add(this._exportGpxItem);
        this._exportPovItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_POVEXPORT);
        this._exportPovItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_POVEXPORT.begin();
            }
        });
        this._exportPovItem.setEnabled(false);
        jMenu.add(this._exportPovItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(I18nManager.getText("menu.file.exit"));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.exit();
            }
        });
        jMenu.add(jMenuItem4);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(I18nManager.getText("menu.edit"));
        jMenu2.setMnemonic(69);
        this._undoItem = new JMenuItem(I18nManager.getText("menu.edit.undo"));
        this._undoAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.beginUndo();
            }
        };
        this._undoItem.addActionListener(this._undoAction);
        this._undoItem.setEnabled(false);
        jMenu2.add(this._undoItem);
        this._clearUndoItem = new JMenuItem(I18nManager.getText("menu.edit.clearundo"));
        this._clearUndoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.clearUndo();
            }
        });
        this._clearUndoItem.setEnabled(false);
        jMenu2.add(this._clearUndoItem);
        jMenu2.addSeparator();
        this._editPointItem = new JMenuItem(I18nManager.getText("menu.edit.editpoint"));
        this._editPointAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.editCurrentPoint();
            }
        };
        this._editPointItem.addActionListener(this._editPointAction);
        this._editPointItem.setEnabled(false);
        jMenu2.add(this._editPointItem);
        this._editWaypointNameItem = new JMenuItem(I18nManager.getText("menu.edit.editwaypointname"));
        this._editWaypointNameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.editCurrentPointName();
            }
        });
        this._editWaypointNameItem.setEnabled(false);
        jMenu2.add(this._editWaypointNameItem);
        this._deletePointItem = new JMenuItem(I18nManager.getText("menu.edit.deletepoint"));
        this._deletePointAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.deleteCurrentPoint();
            }
        };
        this._deletePointItem.addActionListener(this._deletePointAction);
        this._deletePointItem.setEnabled(false);
        jMenu2.add(this._deletePointItem);
        this._deleteRangeItem = new JMenuItem(I18nManager.getText("menu.edit.deleterange"));
        this._deleteRangeAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.deleteSelectedRange();
            }
        };
        this._deleteRangeItem.addActionListener(this._deleteRangeAction);
        this._deleteRangeItem.setEnabled(false);
        jMenu2.add(this._deleteRangeItem);
        jMenu2.addSeparator();
        this._compressItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_COMPRESS);
        this._compressItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_COMPRESS.begin();
            }
        });
        this._compressItem.setEnabled(false);
        jMenu2.add(this._compressItem);
        this._deleteMarkedPointsItem = new JMenuItem(I18nManager.getText("menu.edit.deletemarked"));
        this._deleteMarkedPointsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.finishCompressTrack();
            }
        });
        this._deleteMarkedPointsItem.setEnabled(false);
        jMenu2.add(this._deleteMarkedPointsItem);
        jMenu2.addSeparator();
        this._interpolateItem = new JMenuItem(I18nManager.getText("menu.edit.interpolate"));
        this._interpolateItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.interpolateSelection();
            }
        });
        this._interpolateItem.setEnabled(false);
        jMenu2.add(this._interpolateItem);
        this._averageItem = new JMenuItem(I18nManager.getText("menu.edit.average"));
        this._averageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.averageSelection();
            }
        });
        this._averageItem.setEnabled(false);
        jMenu2.add(this._averageItem);
        this._reverseItem = new JMenuItem(I18nManager.getText("menu.edit.reverse"));
        this._reverseItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.reverseRange();
            }
        });
        this._reverseItem.setEnabled(false);
        jMenu2.add(this._reverseItem);
        this._addTimeOffsetItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ADD_TIME_OFFSET);
        this._addTimeOffsetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_ADD_TIME_OFFSET.begin();
            }
        });
        this._addTimeOffsetItem.setEnabled(false);
        jMenu2.add(this._addTimeOffsetItem);
        this._mergeSegmentsItem = new JMenuItem(I18nManager.getText("menu.edit.mergetracksegments"));
        this._mergeSegmentsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.mergeTrackSegments();
            }
        });
        this._mergeSegmentsItem.setEnabled(false);
        jMenu2.add(this._mergeSegmentsItem);
        this._rearrangeMenu = new JMenu(I18nManager.getText("menu.edit.rearrange"));
        this._rearrangeMenu.setEnabled(false);
        JMenuItem jMenuItem5 = new JMenuItem(I18nManager.getText("menu.edit.rearrange.start"));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_START);
            }
        });
        jMenuItem5.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(I18nManager.getText("menu.edit.rearrange.end"));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_END);
            }
        });
        jMenuItem6.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem(I18nManager.getText("menu.edit.rearrange.nearest"));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_REARRANGE_WAYPOINTS.rearrangeWaypoints(RearrangeWaypointsFunction.Rearrange.TO_NEAREST);
            }
        });
        jMenuItem7.setEnabled(true);
        this._rearrangeMenu.add(jMenuItem7);
        jMenu2.add(this._rearrangeMenu);
        this._cutAndMoveItem = new JMenuItem(I18nManager.getText("menu.edit.cutandmove"));
        this._cutAndMoveItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.cutAndMoveSelection();
            }
        });
        this._cutAndMoveItem.setEnabled(false);
        jMenu2.add(this._cutAndMoveItem);
        jMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(I18nManager.getText("menu.select"));
        this._selectAllItem = new JMenuItem(I18nManager.getText("menu.select.all"));
        this._selectAllItem.setEnabled(false);
        this._selectAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.selectAll();
            }
        });
        jMenu3.add(this._selectAllItem);
        this._selectNoneItem = new JMenuItem(I18nManager.getText("menu.select.none"));
        this._selectNoneItem.setEnabled(false);
        this._selectNoneItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.selectNone();
            }
        });
        jMenu3.add(this._selectNoneItem);
        jMenu3.addSeparator();
        this._selectStartItem = new JMenuItem(I18nManager.getText("menu.select.start"));
        this._selectStartItem.setEnabled(false);
        this._selectStartAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeStart();
            }
        };
        this._selectStartItem.addActionListener(this._selectStartAction);
        jMenu3.add(this._selectStartItem);
        this._selectEndItem = new JMenuItem(I18nManager.getText("menu.select.end"));
        this._selectEndItem.setEnabled(false);
        this._selectEndAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._selection.selectRangeEnd();
            }
        };
        this._selectEndItem.addActionListener(this._selectEndAction);
        jMenu3.add(this._selectEndItem);
        jMenuBar.add(jMenu3);
        JMenu jMenu4 = new JMenu(I18nManager.getText("menu.view"));
        this._show3dItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_3D);
        this._show3dItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_3D.begin();
            }
        });
        this._show3dItem.setEnabled(false);
        jMenu4.add(this._show3dItem);
        this._browserMapMenu = new JMenu(I18nManager.getText("menu.view.browser"));
        this._browserMapMenu.setEnabled(false);
        JMenuItem jMenuItem8 = new JMenuItem(I18nManager.getText("menu.view.browser.google"));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(0);
            }
        });
        this._browserMapMenu.add(jMenuItem8);
        JMenuItem jMenuItem9 = new JMenuItem(I18nManager.getText("menu.view.browser.openstreetmap"));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(1);
            }
        });
        this._browserMapMenu.add(jMenuItem9);
        JMenuItem jMenuItem10 = new JMenuItem(I18nManager.getText("menu.view.browser.mapquest"));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(2);
            }
        });
        this._browserMapMenu.add(jMenuItem10);
        JMenuItem jMenuItem11 = new JMenuItem(I18nManager.getText("menu.view.browser.yahoo"));
        jMenuItem11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.showExternalMap(3);
            }
        });
        this._browserMapMenu.add(jMenuItem11);
        jMenu4.add(this._browserMapMenu);
        this._chartItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHARTS);
        this._chartItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_CHARTS.begin();
            }
        });
        this._chartItem.setEnabled(false);
        jMenu4.add(this._chartItem);
        this._distanceItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_DISTANCES);
        this._distanceItem.setEnabled(false);
        this._distanceItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_DISTANCES.begin();
            }
        });
        jMenu4.add(this._distanceItem);
        JMenuItem jMenuItem12 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_SET_MAP_BG);
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_SET_MAP_BG.begin();
            }
        });
        jMenu4.add(jMenuItem12);
        jMenuBar.add(jMenu4);
        JMenu jMenu5 = new JMenu(I18nManager.getText("menu.photo"));
        jMenuItem2 = new JMenuItem(I18nManager.getText("menu.file.addphotos"));
        jMenuItem2.addActionListener(this._addPhotoAction);
        jMenu5.add(jMenuItem2);
        this._saveExifItem = new JMenuItem(I18nManager.getText("menu.photo.saveexif"));
        this._saveExifItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.saveExif();
            }
        });
        this._saveExifItem.setEnabled(false);
        jMenu5.add(this._saveExifItem);
        this._connectPhotoItem = new JMenuItem(I18nManager.getText("menu.photo.connect"));
        this._connectPhotoAction = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.connectPhotoToPoint();
            }
        };
        this._connectPhotoItem.addActionListener(this._connectPhotoAction);
        this._connectPhotoItem.setEnabled(false);
        jMenu5.addSeparator();
        jMenu5.add(this._connectPhotoItem);
        this._disconnectPhotoItem = new JMenuItem(I18nManager.getText("menu.photo.disconnect"));
        this._disconnectPhotoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.disconnectPhotoFromPoint();
            }
        });
        this._disconnectPhotoItem.setEnabled(false);
        jMenu5.add(this._disconnectPhotoItem);
        this._deletePhotoItem = new JMenuItem(I18nManager.getText("menu.photo.delete"));
        this._deletePhotoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this._app.deleteCurrentPhoto();
            }
        });
        this._deletePhotoItem.setEnabled(false);
        jMenu5.add(this._deletePhotoItem);
        jMenu5.addSeparator();
        this._correlatePhotosItem = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CORRELATE_PHOTOS);
        this._correlatePhotosItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_CORRELATE_PHOTOS.begin();
            }
        });
        this._correlatePhotosItem.setEnabled(false);
        jMenu5.add(this._correlatePhotosItem);
        jMenuBar.add(jMenu5);
        JMenu jMenu6 = new JMenu(I18nManager.getText("menu.help"));
        JMenuItem jMenuItem13 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_HELP);
        jMenuItem13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_HELP.begin();
            }
        });
        jMenu6.add(jMenuItem13);
        JMenuItem jMenuItem14 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_ABOUT);
        jMenuItem14.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_ABOUT.begin();
            }
        });
        jMenu6.add(jMenuItem14);
        JMenuItem jMenuItem15 = MenuManager.makeMenuItem(FunctionLibrary.FUNCTION_CHECK_VERSION);
        jMenuItem15.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FunctionLibrary.FUNCTION_CHECK_VERSION.begin();
            }
        });
        jMenu6.add(jMenuItem15);
        jMenuBar.add(jMenu6);
        return jMenuBar;
    }

    private static JMenuItem makeMenuItem(GenericFunction genericFunction) {
        return new JMenuItem(I18nManager.getText(genericFunction.getNameKey()));
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        JButton jButton = new JButton(IconManager.getImageIcon("add_textfile_icon.png"));
        jButton.setToolTipText(I18nManager.getText("menu.file.open"));
        jButton.addActionListener(this._openFileAction);
        jToolBar.add(jButton);
        JButton jButton2 = new JButton(IconManager.getImageIcon("add_photo_icon.png"));
        jButton2.setToolTipText(I18nManager.getText("menu.file.addphotos"));
        jButton2.addActionListener(this._addPhotoAction);
        jToolBar.add(jButton2);
        this._saveButton = new JButton(IconManager.getImageIcon("save_icon.gif"));
        this._saveButton.setToolTipText(I18nManager.getText("menu.file.save"));
        this._saveButton.addActionListener(this._saveAction);
        this._saveButton.setEnabled(false);
        jToolBar.add(this._saveButton);
        this._undoButton = new JButton(IconManager.getImageIcon("undo_icon.gif"));
        this._undoButton.setToolTipText(I18nManager.getText("menu.edit.undo"));
        this._undoButton.addActionListener(this._undoAction);
        this._undoButton.setEnabled(false);
        jToolBar.add(this._undoButton);
        this._editPointButton = new JButton(IconManager.getImageIcon("edit_point_icon.gif"));
        this._editPointButton.setToolTipText(I18nManager.getText("menu.edit.editpoint"));
        this._editPointButton.addActionListener(this._editPointAction);
        this._editPointButton.setEnabled(false);
        jToolBar.add(this._editPointButton);
        this._deletePointButton = new JButton(IconManager.getImageIcon("delete_point_icon.gif"));
        this._deletePointButton.setToolTipText(I18nManager.getText("menu.edit.deletepoint"));
        this._deletePointButton.addActionListener(this._deletePointAction);
        this._deletePointButton.setEnabled(false);
        jToolBar.add(this._deletePointButton);
        this._deleteRangeButton = new JButton(IconManager.getImageIcon("delete_range_icon.gif"));
        this._deleteRangeButton.setToolTipText(I18nManager.getText("menu.edit.deleterange"));
        this._deleteRangeButton.addActionListener(this._deleteRangeAction);
        this._deleteRangeButton.setEnabled(false);
        jToolBar.add(this._deleteRangeButton);
        this._selectStartButton = new JButton(IconManager.getImageIcon("set_start_icon.png"));
        this._selectStartButton.setToolTipText(I18nManager.getText("menu.select.start"));
        this._selectStartButton.addActionListener(this._selectStartAction);
        this._selectStartButton.setEnabled(false);
        jToolBar.add(this._selectStartButton);
        this._selectEndButton = new JButton(IconManager.getImageIcon("set_end_icon.png"));
        this._selectEndButton.setToolTipText(I18nManager.getText("menu.select.end"));
        this._selectEndButton.addActionListener(this._selectEndAction);
        this._selectEndButton.setEnabled(false);
        jToolBar.add(this._selectEndButton);
        this._connectPhotoButton = new JButton(IconManager.getImageIcon("link.gif"));
        this._connectPhotoButton.setToolTipText(I18nManager.getText("menu.photo.connect"));
        this._connectPhotoButton.addActionListener(this._connectPhotoAction);
        this._connectPhotoButton.setEnabled(false);
        jToolBar.add(this._connectPhotoButton);
        jToolBar.setFloatable(false);
        return jToolBar;
    }

    public void informFileLoaded() {
        this._sendGpsItem.setEnabled(true);
        this._saveItem.setEnabled(true);
        this._undoItem.setEnabled(true);
        this._compressItem.setEnabled(true);
        this._deleteMarkedPointsItem.setEnabled(false);
    }

    public void dataUpdated(byte by) {
        boolean bl = this._track != null && this._track.getNumPoints() > 0;
        this._sendGpsItem.setEnabled(bl);
        this._saveItem.setEnabled(bl);
        this._saveButton.setEnabled(bl);
        this._exportKmlItem.setEnabled(bl);
        this._exportGpxItem.setEnabled(bl);
        this._exportPovItem.setEnabled(bl);
        this._compressItem.setEnabled(bl);
        this._deleteMarkedPointsItem.setEnabled(bl && this._track.hasMarkedPoints());
        this._rearrangeMenu.setEnabled(bl && this._track.hasMixedData());
        this._selectAllItem.setEnabled(bl);
        this._selectNoneItem.setEnabled(bl);
        this._show3dItem.setEnabled(bl);
        this._chartItem.setEnabled(bl);
        this._browserMapMenu.setEnabled(bl);
        this._distanceItem.setEnabled(bl);
        boolean bl2 = !this._app.getUndoStack().isEmpty();
        this._undoItem.setEnabled(bl2);
        this._undoButton.setEnabled(bl2);
        this._clearUndoItem.setEnabled(bl2);
        boolean bl3 = bl && this._selection.getCurrentPointIndex() >= 0;
        this._editPointItem.setEnabled(bl3);
        this._editPointButton.setEnabled(bl3);
        this._editWaypointNameItem.setEnabled(bl3);
        this._deletePointItem.setEnabled(bl3);
        this._deletePointButton.setEnabled(bl3);
        this._selectStartItem.setEnabled(bl3);
        this._selectStartButton.setEnabled(bl3);
        this._selectEndItem.setEnabled(bl3);
        this._selectEndButton.setEnabled(bl3);
        boolean bl4 = this._photos != null && this._photos.getNumPhotos() > 0;
        this._saveExifItem.setEnabled(bl4);
        boolean bl5 = bl4 && this._selection.getCurrentPhotoIndex() >= 0;
        boolean bl6 = bl5 && bl3 && this._photos.getPhoto(this._selection.getCurrentPhotoIndex()) != null && this._photos.getPhoto(this._selection.getCurrentPhotoIndex()).getDataPoint() == null;
        this._connectPhotoItem.setEnabled(bl6);
        this._connectPhotoButton.setEnabled(bl6);
        this._disconnectPhotoItem.setEnabled(bl5 && this._photos.getPhoto(this._selection.getCurrentPhotoIndex()) != null && this._photos.getPhoto(this._selection.getCurrentPhotoIndex()).getDataPoint() != null);
        this._correlatePhotosItem.setEnabled(bl4 && bl);
        this._deletePhotoItem.setEnabled(bl5);
        boolean bl7 = bl && this._selection.hasRangeSelected();
        this._deleteRangeItem.setEnabled(bl7);
        this._deleteRangeButton.setEnabled(bl7);
        this._interpolateItem.setEnabled(bl7 && this._selection.getEnd() - this._selection.getStart() == 1);
        this._averageItem.setEnabled(bl7);
        this._mergeSegmentsItem.setEnabled(bl7);
        this._reverseItem.setEnabled(bl7);
        this._addTimeOffsetItem.setEnabled(bl7);
        this._cutAndMoveItem.setEnabled(bl7 && bl3 && (this._selection.getCurrentPointIndex() < this._selection.getStart() || this._selection.getCurrentPointIndex() > this._selection.getEnd() + 1));
    }

    public void actionCompleted(String string) {
    }
}

