/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import tim.prune.I18nManager;
import tim.prune.data.TrackInfo;
import tim.prune.gui.GenericDisplay;

public abstract class GenericChart
extends GenericDisplay
implements MouseListener {
    protected Dimension MINIMUM_SIZE = new Dimension(200, 250);
    protected static final int BORDER_WIDTH = 8;
    private static final Color COLOR_BORDER_BG = Color.WHITE;
    private static final Color COLOR_CHART_BG = Color.WHITE;
    private static final Color COLOR_CHART_LINE = Color.BLACK;
    private static final Color COLOR_NODATA_TEXT = Color.GRAY;

    protected GenericChart(TrackInfo trackInfo) {
        super(trackInfo);
    }

    public Dimension getMinimumSize() {
        return this.MINIMUM_SIZE;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(COLOR_BORDER_BG);
        graphics.fillRect(0, 0, n, n2);
        if (n < 16 || n2 < 16) {
            return;
        }
        graphics.setColor(COLOR_CHART_BG);
        graphics.fillRect(8, 8, n - 16, n2 - 16);
        if (this._track == null || this._track.getNumPoints() <= 0) {
            graphics.setColor(COLOR_NODATA_TEXT);
            graphics.drawString(I18nManager.getText("display.nodata"), 50, n2 / 2);
        } else {
            graphics.setColor(COLOR_CHART_LINE);
            graphics.drawRect(8, 8, n - 16, n2 - 16);
        }
    }

    public void dataUpdated(byte by) {
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

