/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.ConfigException;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.gui.DetailsDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.MenuManager;
import tim.prune.gui.ProfileChart;
import tim.prune.gui.SelectorDisplay;
import tim.prune.gui.StatusBar;
import tim.prune.gui.map.MapCanvas;

public class GpsPruner {
    public static final String VERSION_NUMBER = "7";
    public static final String BUILD_NUMBER = "136a";
    private static App APP = null;

    public static void main(String[] stringArray) {
        Object object;
        Object object2 = null;
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).startsWith("--locale=")) {
                object2 = GpsPruner.getLanguage(((String)object).substring(9));
            } else if (((String)object).startsWith("--lang=")) {
                object2 = GpsPruner.getLanguage(((String)object).substring(7));
            } else if (((String)object).startsWith("--langfile=")) {
                string = ((String)object).substring(11);
            } else if (((String)object).startsWith("--configfile=")) {
                string2 = ((String)object).substring(13);
            } else {
                if (!((String)object).startsWith("--help")) {
                    System.out.println("Unknown parameter '" + (String)object + "'.");
                }
                bl = true;
            }
            ++n;
        }
        if (bl) {
            System.out.println("Possible parameters:\n   --configfile=<file> used to specify a configuration file\n   --lang=<code> or --locale=<code>  used to specify language\n   --langfile=<file>   used to specify an alternative language file\n");
        }
        try {
            if (string2 != null) {
                Config.loadFile(new File(string2));
            } else {
                Config.loadDefaultFile();
            }
        }
        catch (ConfigException configException) {
            System.err.println("Failed to load config file: " + string2);
        }
        String string3 = Config.getLanguageCode();
        if (object2 == null && string3 != null && (object = GpsPruner.getLanguage(string3)) != null) {
            object2 = object;
        }
        I18nManager.init(object2);
        if (string != null) {
            I18nManager.addLanguageFile(string);
        }
        GpsPruner.launch();
    }

    private static Locale getLanguage(String string) {
        if (string.length() == 2) {
            return new Locale(string);
        }
        if (string.length() == 5) {
            return new Locale(string.substring(0, 2), string.substring(3));
        }
        System.out.println("Unrecognised locale '" + string + "' - value should be eg 'DE' or 'DE_ch'");
        return null;
    }

    private static void launch() {
        JFrame jFrame = new JFrame("Prune");
        APP = new App(jFrame);
        MenuManager menuManager = new MenuManager(APP, APP.getTrackInfo());
        jFrame.setJMenuBar(menuManager.createMenuBar());
        APP.setMenuManager(menuManager);
        UpdateMessageBroker.addSubscriber(menuManager);
        JToolBar jToolBar = menuManager.createToolBar();
        SelectorDisplay selectorDisplay = new SelectorDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(selectorDisplay);
        DetailsDisplay detailsDisplay = new DetailsDisplay(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(detailsDisplay);
        MapCanvas mapCanvas = new MapCanvas(APP, APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(mapCanvas);
        ProfileChart profileChart = new ProfileChart(APP.getTrackInfo());
        UpdateMessageBroker.addSubscriber(profileChart);
        StatusBar statusBar = new StatusBar();
        UpdateMessageBroker.addSubscriber(statusBar);
        UpdateMessageBroker.informSubscribers("Prune v7");
        JSplitPane jSplitPane = new JSplitPane(0, mapCanvas, profileChart);
        jSplitPane.setResizeWeight(1.0);
        JSplitPane jSplitPane2 = new JSplitPane(1, jSplitPane, detailsDisplay);
        jSplitPane2.setResizeWeight(1.0);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jToolBar, "North");
        jFrame.getContentPane().add((Component)new JSplitPane(1, selectorDisplay, jSplitPane2), "Center");
        jFrame.getContentPane().add((Component)statusBar, "South");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                APP.exit();
            }
        });
        jFrame.setDefaultCloseOperation(0);
        try {
            jFrame.setIconImage(IconManager.getImageIcon("window_icon.png").getImage());
        }
        catch (Exception exception) {}
        jFrame.pack();
        jFrame.setSize(650, 450);
        jFrame.setVisible(true);
        jSplitPane.setDividerLocation(0.75);
    }
}

