/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.postgis;

import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooser;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.refractions.postgis.PostGISCommonDriverPanel;
import net.refractions.postgis.PostGISDataSource;

public abstract class PostGISDataSourceQueryChooser
implements DataSourceQueryChooser {
    private static PostGISCommonDriverPanel panel;
    private PostGISDataSource dataSource;
    private HashMap properties;
    JTextField serverField;
    JTextField portField;
    JTextField databaseField;
    JTextField tableField;
    JTextField usernameField;
    JPasswordField passwordField;

    public PostGISDataSourceQueryChooser(PostGISDataSource dataSource) {
        this.dataSource = dataSource;
        if (panel == null) {
            panel = new PostGISCommonDriverPanel();
        }
    }

    public Component getComponent() {
        return panel;
    }

    public abstract Collection getDataSourceQueries();

    public boolean isInputValid() {
        if (panel.getServer().equals("")) {
            return false;
        }
        if (panel.getPort().matches("")) {
            return false;
        }
        if (panel.getDatabase().equals("")) {
            return false;
        }
        if (panel.getTable().equals("")) {
            return false;
        }
        if (panel.getUsername().equals("")) {
            return false;
        }
        return !panel.getPassword().equals("");
    }

    protected HashMap getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put("SERVER", panel.getServer());
        this.properties.put("PORT", panel.getPort());
        this.properties.put("DATABASE", panel.getDatabase());
        this.properties.put("TABLE", panel.getTable());
        this.properties.put("USERNAME", panel.getUsername());
        this.properties.put("PASSWORD", panel.getPassword());
        return this.properties;
    }

    protected PostGISDataSource getDataSource() {
        return this.dataSource;
    }

    public String toString() {
        return "PostGIS Table";
    }
}

