/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.binary;

import org.postgis.binary.ByteSetter;

public abstract class ValueSetter {
    ByteSetter data;
    int position = 0;
    public final byte endian;

    public ValueSetter(ByteSetter byteSetter, byte by) {
        this.data = byteSetter;
        this.endian = by;
    }

    public void setByte(byte by) {
        this.data.set(by, this.position);
        ++this.position;
    }

    public void setInt(int n) {
        this.setInt(n, this.position);
        this.position += 4;
    }

    public void setLong(long l) {
        this.setLong(l, this.position);
        this.position += 8;
    }

    protected abstract void setInt(int var1, int var2);

    protected abstract void setLong(long var1, int var3);

    public void setDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.setLong(l);
    }

    public String toString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2 + "('" + (this.data == null ? "NULL" : this.data.toString() + "')");
    }

    public static class NDR
    extends ValueSetter {
        public static final byte NUMBER = 1;

        public NDR(ByteSetter byteSetter) {
            super(byteSetter, (byte)1);
        }

        protected void setInt(int n, int n2) {
            this.data.set((byte)(n >>> 24), n2 + 3);
            this.data.set((byte)(n >>> 16), n2 + 2);
            this.data.set((byte)(n >>> 8), n2 + 1);
            this.data.set((byte)n, n2);
        }

        protected void setLong(long l, int n) {
            this.data.set((byte)(l >>> 56), n + 7);
            this.data.set((byte)(l >>> 48), n + 6);
            this.data.set((byte)(l >>> 40), n + 5);
            this.data.set((byte)(l >>> 32), n + 4);
            this.data.set((byte)(l >>> 24), n + 3);
            this.data.set((byte)(l >>> 16), n + 2);
            this.data.set((byte)(l >>> 8), n + 1);
            this.data.set((byte)l, n);
        }
    }

    public static class XDR
    extends ValueSetter {
        public static final byte NUMBER = 0;

        public XDR(ByteSetter byteSetter) {
            super(byteSetter, (byte)0);
        }

        protected void setInt(int n, int n2) {
            this.data.set((byte)(n >>> 24), n2);
            this.data.set((byte)(n >>> 16), n2 + 1);
            this.data.set((byte)(n >>> 8), n2 + 2);
            this.data.set((byte)n, n2 + 3);
        }

        protected void setLong(long l, int n) {
            this.data.set((byte)(l >>> 56), n);
            this.data.set((byte)(l >>> 48), n + 1);
            this.data.set((byte)(l >>> 40), n + 2);
            this.data.set((byte)(l >>> 32), n + 3);
            this.data.set((byte)(l >>> 24), n + 4);
            this.data.set((byte)(l >>> 16), n + 5);
            this.data.set((byte)(l >>> 8), n + 6);
            this.data.set((byte)l, n + 7);
        }
    }
}

