#! /usr/bin/env python
# portell.py
# Description: Prints a BSD systems Port's description instantly from whatever directory you're in.
# Author: Ryan "gt3" Kulla
# Email: rkulla@gmail.com
# Version: 0.2
# Usage: portell.py <portname>

import sys, os, shelve

try:
    PORTELL_DB = os.environ['PORTELL_PATH']
except KeyError:
    PORTELL_DB = "/var/db/portell.db"

PORTS_DIR = "/usr/ports/"


def write_pathname(d, dirname, names):
    '/'.join(dirname.split('/')[:5]) # chop port path subdirs
    d[os.path.basename(dirname)] = dirname


def update_db(msg):
    print msg
    
    if os.path.exists(PORTELL_DB):
        os.unlink(PORTELL_DB) 
    if os.path.exists(PORTELL_DB + ".db"):
        os.unlink(PORTELL_DB + ".db") 
        
    try:
        d = shelve.open(PORTELL_DB)
        fix_dbdb()
        os.chmod(PORTELL_DB, 0666) 
    except:
        print "can't read or write %s. are you root?" % PORTELL_DB
        sys.exit(0)

    os.path.walk(PORTS_DIR, write_pathname, d)
    d.close()
    print "done."
    sys.exit(0)


def fix_dbdb():
    # sometimes the os seems to append its own .db extention to files
    if os.path.exists(PORTELL_DB + ".db"):
        os.rename(PORTELL_DB + ".db", PORTELL_DB)


def main():
    if len(sys.argv) != 2:
        print "Usage: %s <portname>" % sys.argv[0]
        print "To update the database: %s -u" % sys.argv[0]
        print "The db will be \"/var/db/portell.db\" or whatever PORTELL_PATH points to"
        sys.exit(0)
	
    if sys.argv[1] == '-u':
        update_db("updating database %s..." % PORTELL_DB)
    elif os.path.exists(PORTELL_DB) == False:
        update_db("creating database %s..." % PORTELL_DB)
    else:
        portname = sys.argv[1]

    d = shelve.open(PORTELL_DB)
    fix_dbdb()

    if d.has_key(portname): 
        if os.uname()[0].lower() == "free":
            descr_path = d[portname] + "/pkg-descr"
        else:
            descr_path = d[portname] + "/pkg/DESCR"
        match = descr_path 
        try:
            descr_file = open(match, 'r').readlines()
            print "%s reads:\n" % descr_path
            for line in descr_file:
                print line,
        except IOError, errmsg:
            print errmsg
    else:
        print >> sys.stderr, "can't find %s's description file" % portname

    d.close()


if __name__=='__main__':
    main()
