/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetNotFoundException;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

public class EmptyWhileStmtRuleTest extends SimpleAggregatorTst {

    private Rule rule;

    public void setUp() throws RuleSetNotFoundException {
        rule = findRule("basic", "EmptyWhileStmt");
    }

    public void testAll() {
        runTests(new TestDescriptor[]{
            new TestDescriptor(TEST1, "bad", 1, rule),
            new TestDescriptor(TEST2, "while(true); ", 1, rule),
        });
    }

    private static final String TEST1 =
            "public class Foo {" + PMD.EOL +
            "    public void bar() {" + PMD.EOL +
            "       while (true == true) {" + PMD.EOL +
            "       }" + PMD.EOL +
            "       while (true == true) {" + PMD.EOL +
            "               String x = \"\";" + PMD.EOL +
            "       }" + PMD.EOL +
            "    }" + PMD.EOL +
            "}";

    private static final String TEST2 =
            "public class Foo {" + PMD.EOL +
            "    public void bar() {" + PMD.EOL +
            "       while (true) " + PMD.EOL +
            "          ; " + PMD.EOL +
            "    }" + PMD.EOL +
            "}";

}
