/**
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */
package test.net.sourceforge.pmd.rules;

import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSetNotFoundException;
import test.net.sourceforge.pmd.testframework.SimpleAggregatorTst;
import test.net.sourceforge.pmd.testframework.TestDescriptor;

public class AssignmentInOperandTest extends SimpleAggregatorTst {

    private Rule rule;

    public void setUp() throws RuleSetNotFoundException {
        rule = findRule("controversial", "AssignmentInOperand");
    }

    public void testAll() {
        runTests(new TestDescriptor[]{
            new TestDescriptor(TEST1, "bad", 1, rule),
            new TestDescriptor(TEST2, "ok", 0, rule),
            new TestDescriptor(TEST3, "assignment in if conditional expression", 0, rule),
            new TestDescriptor(TEST4, "assignment in while conditional expression", 1, rule),
        });
    }

    private static final String TEST1 =
            "public class Foo {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  int x = 2;" + PMD.EOL +
            "  if ((x = getX()) == 3) {" + PMD.EOL +
            "   System.out.println(\"3!\");" + PMD.EOL +
            "  }" + PMD.EOL +
            " }" + PMD.EOL +
            " private int getX() {" + PMD.EOL +
            "  return 3;" + PMD.EOL +
            " }" + PMD.EOL +
            "}";

    private static final String TEST2 =
            "public class Foo {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  if (false) {}" + PMD.EOL +
            " }" + PMD.EOL +
            "}";

    private static final String TEST3 =
            "public class Foo {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  if (false) {" + PMD.EOL +
            "   int x =2;" + PMD.EOL +
            "  }" + PMD.EOL +
            " }" + PMD.EOL +
            "}";

    private static final String TEST4 =
            "public class Foo {" + PMD.EOL +
            " public void bar() {" + PMD.EOL +
            "  int x = 2;" + PMD.EOL +
            "  while ( (x = getX()) != 0 ) {}" + PMD.EOL +
            " }" + PMD.EOL +
            " private int getX() {return 2;}" + PMD.EOL +
            "}";
}
