/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSplitPane;
import net.sourceforge.pmd.TargetJDK1_3;
import net.sourceforge.pmd.TargetJDK1_4;
import net.sourceforge.pmd.TargetJDK1_5;
import net.sourceforge.pmd.TargetJDKVersion;
import net.sourceforge.pmd.ast.ParseException;
import net.sourceforge.pmd.util.viewer.gui.ASTPanel;
import net.sourceforge.pmd.util.viewer.gui.ActionCommands;
import net.sourceforge.pmd.util.viewer.gui.ParseExceptionHandler;
import net.sourceforge.pmd.util.viewer.gui.SourceCodePanel;
import net.sourceforge.pmd.util.viewer.gui.XPathPanel;
import net.sourceforge.pmd.util.viewer.model.ViewerModel;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import net.sourceforge.pmd.util.viewer.util.NLS;

public class MainFrame
extends JFrame
implements ActionListener,
ActionCommands,
ViewerModelListener {
    private ViewerModel model;
    private SourceCodePanel sourcePanel;
    private ASTPanel astPanel;
    private XPathPanel xPathPanel;
    private JButton compileBtn;
    private JButton evalBtn;
    private JLabel statusLbl;
    private JRadioButtonMenuItem jdk13MenuItem;
    private JRadioButtonMenuItem jdk14MenuItem;
    private JRadioButtonMenuItem jdk15MenuItem;

    public MainFrame() {
        super(NLS.nls("MAIN.FRAME.TITLE"));
        this.init();
    }

    private void init() {
        this.model = new ViewerModel();
        this.model.addViewerModelListener(this);
        this.sourcePanel = new SourceCodePanel(this.model);
        this.astPanel = new ASTPanel(this.model);
        this.xPathPanel = new XPathPanel(this.model);
        this.getContentPane().setLayout(new BorderLayout());
        JSplitPane editingPane = new JSplitPane(1, this.sourcePanel, this.astPanel);
        editingPane.setResizeWeight(0.5);
        JPanel interactionsPane = new JPanel(new BorderLayout());
        interactionsPane.add((Component)this.xPathPanel, "South");
        interactionsPane.add((Component)editingPane, "Center");
        this.getContentPane().add((Component)interactionsPane, "Center");
        this.compileBtn = new JButton(NLS.nls("MAIN.FRAME.COMPILE_BUTTON.TITLE"));
        this.compileBtn.setActionCommand("Compile");
        this.compileBtn.addActionListener(this);
        this.evalBtn = new JButton(NLS.nls("MAIN.FRAME.EVALUATE_BUTTON.TITLE"));
        this.evalBtn.setActionCommand("Evaluate");
        this.evalBtn.addActionListener(this);
        this.evalBtn.setEnabled(false);
        this.statusLbl = new JLabel();
        this.statusLbl.setHorizontalAlignment(4);
        JPanel btnPane = new JPanel(new FlowLayout(0));
        btnPane.add(this.compileBtn);
        btnPane.add(this.evalBtn);
        btnPane.add(this.statusLbl);
        this.getContentPane().add((Component)btnPane, "South");
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("JDK");
        ButtonGroup group = new ButtonGroup();
        this.jdk13MenuItem = new JRadioButtonMenuItem("JDK 1.3");
        this.jdk13MenuItem.setSelected(false);
        group.add(this.jdk13MenuItem);
        menu.add(this.jdk13MenuItem);
        this.jdk14MenuItem = new JRadioButtonMenuItem("JDK 1.4");
        this.jdk14MenuItem.setSelected(true);
        group.add(this.jdk14MenuItem);
        menu.add(this.jdk14MenuItem);
        this.jdk15MenuItem = new JRadioButtonMenuItem("JDK 1.5");
        this.jdk15MenuItem.setSelected(false);
        group.add(this.jdk15MenuItem);
        menu.add(this.jdk15MenuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setSize(800, 600);
        this.setVisible(true);
    }

    private TargetJDKVersion createJDKVersion() {
        if (this.jdk14MenuItem.isSelected()) {
            return new TargetJDK1_4();
        }
        if (this.jdk13MenuItem.isSelected()) {
            return new TargetJDK1_3();
        }
        return new TargetJDK1_5();
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Compile")) {
            try {
                long t0 = System.currentTimeMillis();
                this.model.commitSource(this.sourcePanel.getSourceCode(), this.createJDKVersion());
                long t1 = System.currentTimeMillis();
                this.setStatus(NLS.nls("MAIN.FRAME.COMPILATION.TOOK") + " " + (t1 - t0) + " ms");
            }
            catch (ParseException exc) {
                this.setStatus(NLS.nls("MAIN.FRAME.COMPILATION.PROBLEM") + " " + exc.toString());
                new ParseExceptionHandler(this, exc);
            }
        } else if (command.equals("Evaluate")) {
            try {
                long t0 = System.currentTimeMillis();
                this.model.evaluateXPathExpression(this.xPathPanel.getXPathExpression(), this);
                long t1 = System.currentTimeMillis();
                this.setStatus(NLS.nls("MAIN.FRAME.EVALUATION.TOOK") + " " + (t1 - t0) + " ms");
            }
            catch (Exception exc) {
                this.setStatus(NLS.nls("MAIN.FRAME.EVALUATION.PROBLEM") + " " + exc.toString());
                new ParseExceptionHandler(this, exc);
            }
        }
    }

    private void setStatus(String string) {
        this.statusLbl.setText(string == null ? "" : string);
    }

    public void viewerModelChanged(ViewerModelEvent e) {
        this.evalBtn.setEnabled(this.model.hasCompiledTree());
    }
}

