/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.designer;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.dfa.IDataFlowNode;
import net.sourceforge.pmd.dfa.variableaccess.VariableAccess;
import net.sourceforge.pmd.util.HasLines;

public class DFAPanel
extends JComponent
implements ListSelectionListener {
    private DFACanvas dfaCanvas;
    private JList nodeList;
    private DefaultListModel nodes = new DefaultListModel();
    private JPanel wrapperPanel;

    public DFAPanel() {
        this.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        this.nodeList = new JList(this.nodes);
        this.nodeList.setSelectionMode(0);
        this.nodeList.setFixedCellWidth(150);
        this.nodeList.setBorder(BorderFactory.createLineBorder(Color.black));
        this.nodeList.addListSelectionListener(this);
        leftPanel.add(this.nodeList);
        this.add((Component)leftPanel, "West");
        this.dfaCanvas = new DFACanvas();
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(800, 450));
        this.dfaCanvas.setSize(2000, 4000);
        scrollPane.add(this.dfaCanvas);
        this.wrapperPanel = new JPanel();
        this.wrapperPanel.add(scrollPane);
        this.wrapperPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)this.wrapperPanel, "East");
    }

    public void valueChanged(ListSelectionEvent event) {
        ElementWrapper wrapper = null;
        if (this.nodes.size() == 1) {
            wrapper = (ElementWrapper)this.nodes.get(0);
        } else {
            if (this.nodes.isEmpty()) {
                return;
            }
            wrapper = this.nodeList.getSelectedValue() == null ? (ElementWrapper)this.nodes.get(0) : (ElementWrapper)this.nodeList.getSelectedValue();
        }
        this.dfaCanvas.setMethod(wrapper.getNode());
        this.dfaCanvas.repaint();
    }

    public void resetTo(List newNodes, HasLines lines) {
        this.dfaCanvas.setCode(lines);
        this.nodes.clear();
        Iterator i = newNodes.iterator();
        while (i.hasNext()) {
            this.nodes.addElement(new ElementWrapper((ASTMethodDeclaration)i.next()));
        }
        this.nodeList.setSelectedIndex(0);
        this.dfaCanvas.setMethod((SimpleNode)newNodes.get(0));
        this.repaint();
    }

    private static class ElementWrapper {
        private ASTMethodDeclaration node;

        public ElementWrapper(ASTMethodDeclaration node) {
            this.node = node;
        }

        public ASTMethodDeclaration getNode() {
            return this.node;
        }

        public String toString() {
            return this.node.getMethodName();
        }
    }

    public static class DFACanvas
    extends Canvas {
        private static final int NODE_RADIUS = 10;
        private static final int NODE_DIAMETER = 20;
        private SimpleNode node;
        private int x = 150;
        private int y = 50;
        private HasLines lines;

        public void paint(Graphics g) {
            super.paint(g);
            if (this.node == null) {
                return;
            }
            List flow = this.node.getDataFlowNode().getFlow();
            for (int i = 0; i < flow.size(); ++i) {
                IDataFlowNode inode = (IDataFlowNode)flow.get(i);
                this.y = this.computeDrawPos(inode.getIndex());
                g.drawArc(this.x, this.y, 20, 20, 0, 360);
                g.drawString(this.lines.getLine(inode.getLine()), this.x + 200, this.y + 15);
                String idx = String.valueOf(inode.getIndex());
                int hack = 4 * (idx.length() / 2);
                g.drawString(idx, this.x + 10 - 2 - hack, this.y + 10 + 4);
                List access = inode.getVariableAccess();
                if (access != null) {
                    StringBuffer exp = new StringBuffer();
                    for (int k = 0; k < access.size(); ++k) {
                        VariableAccess va = (VariableAccess)access.get(k);
                        if (va.isDefinition()) {
                            exp.append("d(");
                        } else if (va.isReference()) {
                            exp.append("r(");
                        } else if (va.isUndefinition()) {
                            exp.append("u(");
                        } else {
                            exp.append("?(");
                        }
                        exp.append(va.getVariableName() + "), ");
                    }
                    g.drawString(exp.toString(), this.x + 70, this.y + 15);
                }
                for (int j = 0; j < inode.getChildren().size(); ++j) {
                    IDataFlowNode n = (IDataFlowNode)inode.getChildren().get(j);
                    this.drawMyLine(inode.getIndex(), n.getIndex(), g);
                    String output = (j == 0 ? "" : ",") + String.valueOf(n.getIndex());
                    g.drawString(output, this.x - 60 + j * 20, this.y + 10 - 2);
                }
            }
        }

        public void setCode(HasLines h) {
            this.lines = h;
        }

        public void setMethod(SimpleNode node) {
            this.node = node;
        }

        private int computeDrawPos(int index) {
            int z = 40;
            return z + index * z;
        }

        private void drawMyLine(int index1, int index2, Graphics g) {
            int y1 = this.computeDrawPos(index1);
            int y2 = this.computeDrawPos(index2);
            int arrow = 3;
            if (index1 < index2) {
                if (index2 - index1 == 1) {
                    this.x += 10;
                    g.drawLine(this.x, y1 + 20, this.x, y2);
                    g.fillRect(this.x - arrow, y2 - arrow, arrow * 2, arrow * 2);
                    this.x -= 10;
                } else if (index2 - index1 > 1) {
                    int n = (index2 - index1 - 2) * 10 + 10;
                    g.drawLine(this.x, y1 += 10, this.x - n, y1);
                    g.drawLine(this.x - n, y1, this.x - n, y2 += 10);
                    g.drawLine(this.x - n, y2, this.x, y2);
                    g.fillRect(this.x - arrow, y2 - arrow, arrow * 2, arrow * 2);
                }
            } else if (index1 - index2 > 1) {
                this.x += 20;
                int n = (index1 - index2 - 2) * 10 + 10;
                g.drawLine(this.x, y1 += 10, this.x + n, y1);
                g.drawLine(this.x + n, y1, this.x + n, y2 += 10);
                g.drawLine(this.x + n, y2, this.x, y2);
                g.fillRect(this.x - arrow, y2 - arrow, arrow * 2, arrow * 2);
                this.x -= 20;
            } else if (index1 - index2 == 1) {
                g.drawLine(this.x + 10, y2 += 20, this.x + 10, y1);
                g.fillRect(this.x + 10 - arrow, y2 - arrow, arrow * 2, arrow * 2);
            }
        }
    }
}

