/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.junit;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.ast.ASTResultType;
import net.sourceforge.pmd.ast.ASTStatementExpression;
import net.sourceforge.pmd.ast.ASTTypeParameters;
import net.sourceforge.pmd.ast.Node;

public class JUnitTestsShouldContainAsserts
extends AbstractRule
implements Rule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isInterface()) {
            return data;
        }
        return super.visit(node, data);
    }

    public Object visit(ASTMethodDeclaration method, Object data) {
        if (!method.isPublic() || method.isAbstract() || method.isNative() || method.isStatic()) {
            return data;
        }
        Node node = method.jjtGetChild(0);
        if (node instanceof ASTTypeParameters) {
            node = method.jjtGetChild(1);
        }
        if (((ASTResultType)node).isVoid() && method.getMethodName().startsWith("test") && !this.containsAssert(method.getBlock(), false)) {
            this.addViolation(data, method);
        }
        return data;
    }

    private boolean containsAssert(Node n, boolean assertFound) {
        if (!assertFound) {
            if (n instanceof ASTStatementExpression && this.isAssertOrFailStatement((ASTStatementExpression)n)) {
                return true;
            }
            if (!assertFound) {
                for (int i = 0; i < n.jjtGetNumChildren() && !assertFound; ++i) {
                    Node c = n.jjtGetChild(i);
                    if (!this.containsAssert(c, assertFound)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isAssertOrFailStatement(ASTStatementExpression expression) {
        ASTName n;
        ASTPrimaryPrefix pp;
        ASTPrimaryExpression pe;
        return expression != null && expression.jjtGetNumChildren() > 0 && expression.jjtGetChild(0) instanceof ASTPrimaryExpression && (pe = (ASTPrimaryExpression)expression.jjtGetChild(0)).jjtGetNumChildren() > 0 && pe.jjtGetChild(0) instanceof ASTPrimaryPrefix && (pp = (ASTPrimaryPrefix)pe.jjtGetChild(0)).jjtGetNumChildren() > 0 && pp.jjtGetChild(0) instanceof ASTName && (n = (ASTName)pp.jjtGetChild(0)).getImage() != null && (n.getImage().startsWith("assert") || n.getImage().startsWith("fail"));
    }
}

