/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.symboltable.NameOccurrence;
import net.sourceforge.pmd.symboltable.VariableNameDeclaration;

public class UnusedPrivateFieldRule
extends AbstractRule {
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        Map vars = node.getScope().getVariableDeclarations();
        Iterator i = vars.keySet().iterator();
        while (i.hasNext()) {
            VariableNameDeclaration decl = (VariableNameDeclaration)i.next();
            if (!decl.getAccessNodeParent().isPrivate() || this.isOK(decl.getImage()) || this.actuallyUsed((List)vars.get(decl))) continue;
            this.addViolation(data, decl.getNode(), decl.getImage());
        }
        return super.visit(node, data);
    }

    private boolean actuallyUsed(List usages) {
        Iterator j = usages.iterator();
        while (j.hasNext()) {
            NameOccurrence nameOccurrence = (NameOccurrence)j.next();
            if (nameOccurrence.isOnLeftHandSide()) continue;
            return true;
        }
        return false;
    }

    private boolean isOK(String image) {
        return image.equals("serialVersionUID") || image.equals("serialPersistentFields") || image.equals("IDENT");
    }
}

