/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;

public class TextRenderer
extends AbstractRenderer
implements Renderer {
    public String render(Report report) {
        StringBuffer buf = new StringBuffer();
        if (report.isEmpty()) {
            buf.append("No problems found!");
            if (this.showSuppressedViolations) {
                this.addSuppressed(report, buf);
            }
            return buf.toString();
        }
        Iterator i = report.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            buf.append(PMD.EOL + rv.getFilename());
            buf.append(":" + Integer.toString(rv.getBeginLine()));
            buf.append("\t" + rv.getDescription());
        }
        i = report.errors();
        while (i.hasNext()) {
            Report.ProcessingError error = (Report.ProcessingError)i.next();
            buf.append(PMD.EOL + error.getFile());
            buf.append("\t-");
            buf.append("\t" + error.getMsg());
        }
        if (this.showSuppressedViolations) {
            this.addSuppressed(report, buf);
        }
        return buf.toString();
    }

    private void addSuppressed(Report report, StringBuffer buf) {
        Iterator i = report.getSuppressedRuleViolations().iterator();
        while (i.hasNext()) {
            Report.SuppressedViolation excluded = (Report.SuppressedViolation)i.next();
            buf.append(PMD.EOL + excluded.getRuleViolation().getRule().getName() + " rule violation suppressed by " + (excluded.suppressedByNOPMD() ? "//NOPMD" : "Annotation") + " in " + excluded.getRuleViolation().getFilename());
        }
    }
}

