/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.util.Iterator;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.PMD;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.util.StringUtil;

public class CSVRenderer
extends AbstractRenderer
implements Renderer {
    public String render(Report report) {
        StringBuffer buf = new StringBuffer(this.quoteAndCommify("Problem"));
        buf.append(this.quoteAndCommify("Package"));
        buf.append(this.quoteAndCommify("File"));
        buf.append(this.quoteAndCommify("Line"));
        buf.append(this.quoteAndCommify("Priority"));
        buf.append(this.quoteAndCommify("Description"));
        buf.append(this.quoteAndCommify("Rule set"));
        buf.append(this.quote("Rule"));
        buf.append(PMD.EOL);
        int violationCount = 1;
        Iterator i = report.iterator();
        while (i.hasNext()) {
            IRuleViolation rv = (IRuleViolation)i.next();
            buf.append(this.quoteAndCommify(Integer.toString(violationCount)));
            buf.append(this.quoteAndCommify(rv.getPackageName()));
            buf.append(this.quoteAndCommify(rv.getFilename()));
            buf.append(this.quoteAndCommify(Integer.toString(rv.getRule().getPriority())));
            buf.append(this.quoteAndCommify(Integer.toString(rv.getBeginLine())));
            buf.append(this.quoteAndCommify(StringUtil.replaceString(rv.getDescription(), '\"', "'")));
            buf.append(this.quoteAndCommify(rv.getRule().getRuleSetName()));
            buf.append(this.quote(rv.getRule().getName()));
            buf.append(PMD.EOL);
            ++violationCount;
        }
        return buf.toString();
    }

    private String quote(String d) {
        return "\"" + d + "\"";
    }

    private String quoteAndCommify(String d) {
        return this.quote(d) + ",";
    }
}

